/**
 *  Chunk Library
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CChunk_H
#define __CChunk_H

#include <cstdlib>
#include <cstring>

#include <stdint.h>

#include <vector>
#include <string>

// [Chunk format]
// 0x00 (Int) size of chunk 
// 0x04 (Int) number of data slots
// 0x08 (Int) version of chunk
// 0x0c (Int) 0
// 0x10 ~ DATA SLOTS
// [Slot format]
// +0x00 (Int) type of slot
// +0x04 (Int) size of slot //< Int data
// +0x08 ~ data //< String, Float data

typedef struct
{
  int32_t sizeOfChunk;
  int32_t numberOfSlot;
  int32_t versionOfSlot;
  int32_t data;
} CChunkHead;

typedef struct
{
  int32_t numberOfSlot;
  int32_t typeOfSlot;
  int32_t sizeOfData;
} CChunkSlot;

class CChunk
{
public:
  CChunk();
  ~CChunk();
  int registerChunk(int size, void * data);
  int getChunk(int * size, void ** data);
  int getNumberOfSlots();
  int getVLSize();
  int getVTSize();
  void setVersion(int version);
  int getVersion();
  int getSlotString(int slot, char ** data);
  int getSlotInt(int slot, int * value);
  int getSlotFloat(int slot, float * value);
  void clear();
  int setSlotString(int slot, const char * data);
  int setSlotInt(int slot, int value);
  int setSlotFloat(int slot, float value);
  void addSlot(int slot, int type);
private:
  int isValid;
  CChunkHead chunkHead;
  std::vector<CChunkSlot> chunkSlotVector;
  std::vector<std::string> chunkStringVector;
  std::vector<float> chunkFloatVector;
  unsigned char * chunkData;
};

enum {
  kStringType = 0, kIntType = 1, kFloatType = 2,
};

#endif
