﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Outline.Properties;

namespace Outline
{
    public partial class ConfigForm : Form
    {
        Dictionary<string, string[]> tempOutlineAnalyzePattern = new Dictionary<string, string[]>();
        Dictionary<string, string[]> OutlineAnalyzePattern;

        public ConfigForm()
        {
            InitializeComponent();
        }

        public ConfigForm(Dictionary<string, string[]> OutlineAnalyzePattern) : this()
        {
            this.OutlineAnalyzePattern = OutlineAnalyzePattern;
        }

        protected override void OnLoad(EventArgs e)
        {
            foreach (string s in this.OutlineAnalyzePattern.Keys)
            {
                this.listBox2.Items.Add(s);
                this.tempOutlineAnalyzePattern.Add(s, this.OutlineAnalyzePattern[s]);
            }
            base.OnLoad(e);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            SaveAnalyzePattern();
            this.OutlineAnalyzePattern.Clear();
            foreach (KeyValuePair<string, string[]> kv in this.tempOutlineAnalyzePattern)
                this.OutlineAnalyzePattern.Add(kv.Key, kv.Value);
            this.Close();
        }

        private void listBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            string key = (string)this.listBox2.SelectedItem;
            if (key == null)
            {
                this.textBox4.Text = string.Empty;
                this.textBox3.Text = string.Empty;
                return;
            }
            SaveAnalyzePattern();
            this.textBox4.Text = key;
            this.textBox3.Text = string.Join(Environment.NewLine, this.tempOutlineAnalyzePattern[key]);
        }

        private void button8_Click(object sender, EventArgs e)
        {
            string key = Resources.AnalyzePatternNewItem + this.tempOutlineAnalyzePattern.Count;
            this.tempOutlineAnalyzePattern.Add(key, new string[] { });
            this.listBox2.Items.Add(key);
        }

        void SaveAnalyzePattern()
        {
            string key = this.textBox4.Text;
            string value = this.textBox3.Text;
            if (key != string.Empty && value != string.Empty)
                this.tempOutlineAnalyzePattern[key] = value.Split(new string[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            string key = (string)this.listBox2.SelectedItem;
            this.tempOutlineAnalyzePattern.Remove(key);
            this.listBox2.Items.Remove(key);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

    }
}
