﻿using System;
using System.Windows.Forms;
using FooEditor.Plugin;

namespace FooEditor
{
    class PipeCommandListener
    {
        MainForm form;
        Editor editor;

        public PipeCommandListener(MainForm form, Editor editor)
        {
            this.form = form;
            this.editor = editor;
        }

        public void Execute(string data)
        {
            string[] cmd = data.Split('\t');

            switch (cmd[0])
            {
                case "NEWDOC":
                    form.BeginInvoke((MethodInvoker)delegate() { this.editor.CreateNew(); });
                    break;
                case "OPEN":
                    if (cmd.Length >= 2)
                        form.BeginInvoke((MethodInvoker)delegate() {
                            EditForm newForm = this.editor.CreateNew();
                            newForm.LoadFile(cmd[1], null);
                        });
                    break;
                case "LINEJUMP":
                    if (cmd.Length >= 2)
                        form.BeginInvoke((MethodInvoker)delegate()
                        {
                            EditForm active = this.editor.EditForm;
                            if (active == null)
                                return;
                            int lineno = Int32.Parse(cmd[1]);
                            if (lineno > active.fooTextBox1.LayoutLines.Count)
                                return;
                            active.fooTextBox1.JumpCaret(lineno, 0);
                            active.fooTextBox1.Refresh();
                        });
                    break;
                case "ACTIVE":
                    form.BeginInvoke((MethodInvoker)delegate() { form.Activate(); });
                    break;
            }
        }
    }
}
