﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using Windows.Graphics.Display;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Imaging;
using SharpDX;
using SharpDX.WIC;
using DXGI = SharpDX.DXGI;
using D2D = SharpDX.Direct2D1;
using D3D = SharpDX.Direct3D;
using D3D11 = SharpDX.Direct3D11;
using FooEditEngine.Metro;
using DotNetTextStore;
using DotNetTextStore.UnmanagedAPI.TSF;
using DotNetTextStore.UnmanagedAPI.WinDef;

namespace FooEditEngine
{
    sealed class D2DPrintRender : D2DRenderBase, ITextRender, IPrintableTextRender
    {
        D2D.Device D2DDevice;
        D2D.DeviceContext D2DContext;
        D2D.PrintControl Control;
        D2D.CommandList CommandList;
        Size2F Size;
        ImagingFactory WICFactory = new ImagingFactory();
        int dpi;

        public D2DPrintRender(string fontName,double fontSize, Size size, uint dpi, IPrintDocumentPackageTarget docPackageTarget)
            : base()
        {
            base.ConstructDeviceResource(size.Width, size.Height);
            base.InitTextFormat(fontName, (float)fontSize);

            this.CreateSurface(size,dpi,docPackageTarget);
        }

        public override void GetDpi(out float dpix, out float dpiy)
        {
            dpix = this.dpi;
            dpiy = this.dpi;
        }

        public void DrawContent(PrintableView view)
        {
            this.CommandList = new D2D.CommandList(this.D2DContext);
            this.D2DContext.Target = this.CommandList;
            base.BegineDraw();
            view.Draw(view.PageBound);
            base.EndDraw();
            this.CommandList.Close();
            this.Control.AddPage(this.CommandList, this.Size);
            this.CommandList.Dispose();
        }

        void CreateSurface(Size size, uint dpi, IPrintDocumentPackageTarget docPackageTarget)
        {
            D2D.PrintControlProperties printControlProperties = new D2D.PrintControlProperties();
            printControlProperties.RasterDPI = dpi;
            printControlProperties.ColorSpace = D2D.ColorSpace.SRgb;
            printControlProperties.FontSubset = D2D.PrintFontSubsetMode.Default;

            this.Control = new D2D.PrintControl(this.D2DDevice, this.WICFactory, new ComObject(docPackageTarget), printControlProperties);

            this.Size = new Size2F((float)size.Width, (float)size.Height);

            this.dpi = (int)dpi;
        }

        protected override D2D.RenderTarget ConstructRender(D2D.Factory1 factory, D2D.RenderTargetProperties prop, double width, double height)
        {
            this.D2DDevice = new D2D.Device(factory,this.DXGIDevice);
            this.D2DContext = new D2D.DeviceContext(this.D2DDevice, D2D.DeviceContextOptions.None);
            return this.D2DContext;
        }

        protected override void ConstrctedResource()
        {
        }

        protected override void DestructRender()
        {
            if (this.Control != null)
            {
                this.Control.Close();
                this.Control.Dispose();
            }
            if (this.WICFactory != null)
                this.WICFactory.Dispose();
            if (this.D2DDevice != null)
                this.D2DDevice.Dispose();
            if (this.D2DContext != null)
                this.D2DContext.Dispose();
        }

        protected override void ReCreateTarget()
        {
        }

        public float HeaderHeight
        {
            get { return (float)this.emSize.Height; }
        }

        public float FooterHeight
        {
            get { return (float)this.emSize.Height; }
        }
    }
}
