/*
 * Copyright 2009-2013 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of WEB_CONFIG_TO_LABEL_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign table]
 *     LABEL_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer table]
 *     
 * 
 * [foreign property]
 *     labelType, webCrawlingConfig
 * 
 * [referrer property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToLabelTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    @Override
    public String getTableDbName() {
        return "WEB_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    @Override
    public DBMeta getDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToLabelTypeMappingDbm getMyDBMeta() {
        return WebConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    @Override
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebConfigToLabelTypeMapping newMyEntity() {
        return new WebConfigToLabelTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebConfigToLabelTypeMappingCB newMyConditionBean() {
        return new WebConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(final WebConfigToLabelTypeMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(final WebConfigToLabelTypeMappingCB cb) { // called by selectCount(cb) 
        assertCBStateValid(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(final WebConfigToLabelTypeMappingCB cb) { // called by selectPage(cb)
        assertCBStateValid(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(final ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebConfigToLabelTypeMapping&gt;() {
     *     public void handle(WebConfigToLabelTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(final WebConfigToLabelTypeMappingCB cb,
            final EntityRowHandler<WebConfigToLabelTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> void doSelectCursor(
            final WebConfigToLabelTypeMappingCB cb,
            final EntityRowHandler<ENTITY> entityRowHandler,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToLabelTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webConfigToLabelTypeMapping != null) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectEntity(
            final WebConfigToLabelTypeMappingCB cb) {
        return doSelectEntity(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectEntity(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(final ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webConfigToLabelTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            final WebConfigToLabelTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(final ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectByPKValue(final Long id) {
        return doSelectByPKValue(id, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectByPKValue(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(
            final Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebConfigToLabelTypeMappingCB buildPKCB(final Long id) {
        assertObjectNotNull("id", id);
        final WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebConfigToLabelTypeMapping&gt; webConfigToLabelTypeMappingList = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebConfigToLabelTypeMapping webConfigToLabelTypeMapping : webConfigToLabelTypeMappingList) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebConfigToLabelTypeMapping> selectList(
            final WebConfigToLabelTypeMappingCB cb) {
        return doSelectList(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> ListResultBean<ENTITY> doSelectList(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToLabelTypeMappingCB cb,
                            final Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(final ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebConfigToLabelTypeMapping&gt; page = webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebConfigToLabelTypeMapping webConfigToLabelTypeMapping : page) {
     *     ... = webConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebConfigToLabelTypeMapping> selectPage(
            final WebConfigToLabelTypeMappingCB cb) {
        return doSelectPage(cb, WebConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            final WebConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, WebConfigToLabelTypeMappingCB>() {
                    @Override
                    public int callbackSelectCount(
                            final WebConfigToLabelTypeMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToLabelTypeMappingCB cb,
                            final Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(
            final ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<WebConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            final Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebConfigToLabelTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            final Class<RESULT> resultType, final CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBStateValid(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        final String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, LabelType>() {
                    @Override
                    public LabelType getFr(final WebConfigToLabelTypeMapping e) {
                        return e.getLabelType();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final LabelType e,
                            final List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToLabelTypeMappingList The list of webConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                webConfigToLabelTypeMappingList,
                new InternalPulloutCallback<WebConfigToLabelTypeMapping, WebCrawlingConfig>() {
                    @Override
                    public WebCrawlingConfig getFr(
                            final WebConfigToLabelTypeMapping e) {
                        return e.getWebCrawlingConfig();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final WebCrawlingConfig e,
                            final List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToLabelTypeMapping.setFoo...(value);
     * webConfigToLabelTypeMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.set...;</span>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">insert</span>(webConfigToLabelTypeMapping);
     * ... = webConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        doInsert(webConfigToLabelTypeMapping, null);
    }

    protected void doInsert(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMapping",
                webConfigToLabelTypeMapping);
        prepareInsertOption(option);
        delegateInsert(webConfigToLabelTypeMapping, option);
    }

    protected void prepareInsertOption(
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    protected void doCreate(final Entity entity,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), downcast(option));
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">update</span>(webConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        doUpdate(webConfigToLabelTypeMapping, null);
    }

    protected void doUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMapping",
                webConfigToLabelTypeMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(webConfigToLabelTypeMapping,
                new InternalUpdateCallback<WebConfigToLabelTypeMapping>() {
                    @Override
                    public int callbackDelegateUpdate(
                            final WebConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected WebConfigToLabelTypeMappingCB createCBForVaryingUpdate() {
        final WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected WebConfigToLabelTypeMappingCB createCBForSpecifiedUpdate() {
        final WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    protected void doModify(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doModifyNonstrict(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        doInesrtOrUpdate(webConfigToLabelTypeMapping, null, null);
    }

    protected void doInesrtOrUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final InsertOption<WebConfigToLabelTypeMappingCB> insertOption,
            final UpdateOption<WebConfigToLabelTypeMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                webConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>() {
                    @Override
                    public void callbackInsert(
                            final WebConfigToLabelTypeMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    @Override
                    public void callbackUpdate(
                            final WebConfigToLabelTypeMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    @Override
                    public WebConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    @Override
                    public int callbackSelectCount(
                            final WebConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrModify(final Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption<WebConfigToLabelTypeMappingCB>()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption<WebConfigToLabelTypeMappingCB>()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity), downcast(insertOption),
                    downcast(updateOption));
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(final Entity entity,
            final InsertOption<? extends ConditionBean> insertOption,
            final UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">delete</span>(webConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping) {
        doDelete(webConfigToLabelTypeMapping, null);
    }

    protected void doDelete(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMapping",
                webConfigToLabelTypeMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(webConfigToLabelTypeMapping,
                new InternalDeleteCallback<WebConfigToLabelTypeMapping>() {
                    @Override
                    public int callbackDelegateDelete(
                            final WebConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    protected void doRemove(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doRemoveNonstrict(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return doBatchInsert(webConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchInsert(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(webConfigToLabelTypeMappingList, option);
    }

    @Override
    protected int[] doLumpCreate(final List<Entity> ls,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert(downcast(ls));
        } else {
            return varyingBatchInsert(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return doBatchUpdate(webConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchUpdate(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(webConfigToLabelTypeMappingList, option);
    }

    @Override
    protected int[] doLumpModify(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate(downcast(ls));
        } else {
            return varyingBatchUpdate(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final SpecifyQuery<WebConfigToLabelTypeMappingCB> updateColumnSpec) {
        return doBatchUpdate(webConfigToLabelTypeMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        return doBatchDelete(webConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchDelete(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMappingList",
                webConfigToLabelTypeMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(webConfigToLabelTypeMappingList, option);
    }

    @Override
    protected int[] doLumpRemove(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete(downcast(ls));
        } else {
            return varyingBatchDelete(downcast(ls), downcast(option));
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB&gt;() {
     *     public ConditionBean setup(webConfigToLabelTypeMapping entity, WebConfigToLabelTypeMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            final QueryInsertSetupper<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            final QueryInsertSetupper<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB> setupper,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        final WebConfigToLabelTypeMapping entity = new WebConfigToLabelTypeMapping();
        final WebConfigToLabelTypeMappingCB intoCB = createCBForQueryInsert();
        final ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected WebConfigToLabelTypeMappingCB createCBForQueryInsert() {
        final WebConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    protected int doRangeCreate(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert(downcast(setupper));
        } else {
            return varyingQueryInsert(downcast(setupper), downcast(option));
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setPK...(value);</span>
     * webConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setVersionNo(value);</span>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(webConfigToLabelTypeMapping, cb);
     * </pre>
     * @param webConfigToLabelTypeMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final WebConfigToLabelTypeMappingCB cb) {
        return doQueryUpdate(webConfigToLabelTypeMapping, cb, null);
    }

    protected int doQueryUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final WebConfigToLabelTypeMappingCB cb,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("webConfigToLabelTypeMapping",
                webConfigToLabelTypeMapping);
        assertCBStateValid(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(webConfigToLabelTypeMapping, cb, option);
    }

    @Override
    protected int doRangeModify(final Entity entity, final ConditionBean cb,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity),
                    (WebConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (WebConfigToLabelTypeMappingCB) cb, downcast(option));
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(webConfigToLabelTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(final WebConfigToLabelTypeMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(final WebConfigToLabelTypeMappingCB cb,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertCBStateValid(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    protected int doRangeRemove(final ConditionBean cb,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((WebConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryDelete((WebConfigToLabelTypeMappingCB) cb,
                    downcast(option));
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToLabelTypeMapping.setFoo...(value);
     * webConfigToLabelTypeMapping.setBar...(value);
     * InsertOption<WebConfigToLabelTypeMappingCB> option = new InsertOption<WebConfigToLabelTypeMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingInsert</span>(webConfigToLabelTypeMapping, option);
     * ... = webConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(webConfigToLabelTypeMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * webConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *         public void specify(WebConfigToLabelTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(webConfigToLabelTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(webConfigToLabelTypeMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param webConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final InsertOption<WebConfigToLabelTypeMappingCB> insertOption,
            final UpdateOption<WebConfigToLabelTypeMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(webConfigToLabelTypeMapping, insertOption,
                updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param webConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(webConfigToLabelTypeMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(webConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(webConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param webConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(webConfigToLabelTypeMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            final QueryInsertSetupper<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB> setupper,
            final InsertOption<WebConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebConfigToLabelTypeMapping webConfigToLabelTypeMapping = new WebConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setPK...(value);</span>
     * webConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToLabelTypeMapping.setVersionNo(value);</span>
     * WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToLabelTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void specify(WebConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webConfigToLabelTypeMapping, cb, option);
     * </pre>
     * @param webConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(
            final WebConfigToLabelTypeMapping webConfigToLabelTypeMapping,
            final WebConfigToLabelTypeMappingCB cb,
            final UpdateOption<WebConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(webConfigToLabelTypeMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of WebConfigToLabelTypeMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(final WebConfigToLabelTypeMappingCB cb,
            final DeleteOption<WebConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<WebConfigToLabelTypeMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(
            final WebConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(
            final WebConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> void delegateSelectCursor(
            final WebConfigToLabelTypeMappingCB cb,
            final EntityRowHandler<ENTITY> erh, final Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends WebConfigToLabelTypeMapping> List<ENTITY> delegateSelectList(
            final WebConfigToLabelTypeMappingCB cb, final Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(final WebConfigToLabelTypeMapping e,
            final InsertOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(final WebConfigToLabelTypeMapping e,
            final UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(final WebConfigToLabelTypeMapping e,
            final UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(final WebConfigToLabelTypeMapping e,
            final DeleteOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(final WebConfigToLabelTypeMapping e,
            final DeleteOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(
            final List<WebConfigToLabelTypeMapping> ls,
            final InsertOption<WebConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(
            final List<WebConfigToLabelTypeMapping> ls,
            final UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(
            final List<WebConfigToLabelTypeMapping> ls,
            final UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(
            final List<WebConfigToLabelTypeMapping> ls,
            final DeleteOption<WebConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(
            final List<WebConfigToLabelTypeMapping> ls,
            final DeleteOption<WebConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(final WebConfigToLabelTypeMapping e,
            final WebConfigToLabelTypeMappingCB inCB,
            final ConditionBean resCB,
            final InsertOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(final WebConfigToLabelTypeMapping e,
            final WebConfigToLabelTypeMappingCB cb,
            final UpdateOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(final WebConfigToLabelTypeMappingCB cb,
            final DeleteOption<WebConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(final Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(final Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebConfigToLabelTypeMapping downcast(final Entity entity) {
        return helpEntityDowncastInternally(entity,
                WebConfigToLabelTypeMapping.class);
    }

    protected WebConfigToLabelTypeMappingCB downcast(final ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebConfigToLabelTypeMappingCB.class);
    }

    @SuppressWarnings("unchecked")
    protected List<WebConfigToLabelTypeMapping> downcast(
            final List<? extends Entity> entityList) {
        return (List<WebConfigToLabelTypeMapping>) entityList;
    }

    @SuppressWarnings("unchecked")
    protected InsertOption<WebConfigToLabelTypeMappingCB> downcast(
            final InsertOption<? extends ConditionBean> option) {
        return (InsertOption<WebConfigToLabelTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected UpdateOption<WebConfigToLabelTypeMappingCB> downcast(
            final UpdateOption<? extends ConditionBean> option) {
        return (UpdateOption<WebConfigToLabelTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected DeleteOption<WebConfigToLabelTypeMappingCB> downcast(
            final DeleteOption<? extends ConditionBean> option) {
        return (DeleteOption<WebConfigToLabelTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected QueryInsertSetupper<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB> downcast(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> option) {
        return (QueryInsertSetupper<WebConfigToLabelTypeMapping, WebConfigToLabelTypeMappingCB>) option;
    }
}
