/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of FILE_CRAWLING_CONFIG. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class FileCrawlingConfigDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final FileCrawlingConfigDbm _instance = new FileCrawlingConfigDbm();

    private FileCrawlingConfigDbm() {
    }

    public static FileCrawlingConfigDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "FILE_CRAWLING_CONFIG";

    protected final String _tablePropertyName = "fileCrawlingConfig";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "FILE_CRAWLING_CONFIG", _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    @Override
    public String getTableDbName() {
        return _tableDbName;
    }

    @Override
    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    @Override
    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci(
            "ID",
            "ID",
            null,
            null,
            true,
            "id",
            Long.class,
            true,
            true,
            "BIGINT",
            19,
            0,
            false,
            null,
            null,
            null,
            "failureUrlList,fileAuthenticationList,fileConfigToBrowserTypeMappingList,fileConfigToLabelTypeMappingList,fileConfigToRoleTypeMappingList",
            null);

    protected final ColumnInfo _columnName = cci("NAME", "NAME", null, null,
            true, "name", String.class, false, false, "VARCHAR", 200, 0, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnPaths = cci("PATHS", "PATHS", null, null,
            true, "paths", String.class, false, false, "VARCHAR", 4000, 0,
            false, null, null, null, null, null);

    protected final ColumnInfo _columnIncludedPaths = cci("INCLUDED_PATHS",
            "INCLUDED_PATHS", null, null, false, "includedPaths", String.class,
            false, false, "VARCHAR", 4000, 0, false, null, null, null, null,
            null);

    protected final ColumnInfo _columnExcludedPaths = cci("EXCLUDED_PATHS",
            "EXCLUDED_PATHS", null, null, false, "excludedPaths", String.class,
            false, false, "VARCHAR", 4000, 0, false, null, null, null, null,
            null);

    protected final ColumnInfo _columnIncludedDocPaths = cci(
            "INCLUDED_DOC_PATHS", "INCLUDED_DOC_PATHS", null, null, false,
            "includedDocPaths", String.class, false, false, "VARCHAR", 4000, 0,
            false, null, null, null, null, null);

    protected final ColumnInfo _columnExcludedDocPaths = cci(
            "EXCLUDED_DOC_PATHS", "EXCLUDED_DOC_PATHS", null, null, false,
            "excludedDocPaths", String.class, false, false, "VARCHAR", 4000, 0,
            false, null, null, null, null, null);

    protected final ColumnInfo _columnDepth = cci("DEPTH", "DEPTH", null, null,
            false, "depth", Integer.class, false, false, "INTEGER", 10, 0,
            false, null, null, null, null, null);

    protected final ColumnInfo _columnMaxAccessCount = cci("MAX_ACCESS_COUNT",
            "MAX_ACCESS_COUNT", null, null, false, "maxAccessCount",
            Long.class, false, false, "BIGINT", 19, 0, false, null, null, null,
            null, null);

    protected final ColumnInfo _columnNumOfThread = cci("NUM_OF_THREAD",
            "NUM_OF_THREAD", null, null, true, "numOfThread", Integer.class,
            false, false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnIntervalTime = cci("INTERVAL_TIME",
            "INTERVAL_TIME", null, null, true, "intervalTime", Integer.class,
            false, false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnBoost = cci("BOOST", "BOOST", null, null,
            true, "boost", java.math.BigDecimal.class, false, false, "DOUBLE",
            17, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnAvailable = cci("AVAILABLE", "AVAILABLE",
            null, null, true, "available", String.class, false, false,
            "VARCHAR", 1, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnSortOrder = cci("SORT_ORDER",
            "SORT_ORDER", null, null, true, "sortOrder", Integer.class, false,
            false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedBy = cci("CREATED_BY",
            "CREATED_BY", null, null, true, "createdBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedTime = cci("CREATED_TIME",
            "CREATED_TIME", null, null, true, "createdTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedBy = cci("UPDATED_BY",
            "UPDATED_BY", null, null, false, "updatedBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME",
            "UPDATED_TIME", null, null, false, "updatedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnDeletedBy = cci("DELETED_BY",
            "DELETED_BY", null, null, false, "deletedBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnDeletedTime = cci("DELETED_TIME",
            "DELETED_TIME", null, null, false, "deletedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnVersionNo = cci("VERSION_NO",
            "VERSION_NO", null, null, true, "versionNo", Integer.class, false,
            false, "INTEGER", 10, 0, false, OptimisticLockType.VERSION_NO,
            null, null, null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnName() {
        return _columnName;
    }

    public ColumnInfo columnPaths() {
        return _columnPaths;
    }

    public ColumnInfo columnIncludedPaths() {
        return _columnIncludedPaths;
    }

    public ColumnInfo columnExcludedPaths() {
        return _columnExcludedPaths;
    }

    public ColumnInfo columnIncludedDocPaths() {
        return _columnIncludedDocPaths;
    }

    public ColumnInfo columnExcludedDocPaths() {
        return _columnExcludedDocPaths;
    }

    public ColumnInfo columnDepth() {
        return _columnDepth;
    }

    public ColumnInfo columnMaxAccessCount() {
        return _columnMaxAccessCount;
    }

    public ColumnInfo columnNumOfThread() {
        return _columnNumOfThread;
    }

    public ColumnInfo columnIntervalTime() {
        return _columnIntervalTime;
    }

    public ColumnInfo columnBoost() {
        return _columnBoost;
    }

    public ColumnInfo columnAvailable() {
        return _columnAvailable;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    @Override
    protected List<ColumnInfo> ccil() {
        final List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnName());
        ls.add(columnPaths());
        ls.add(columnIncludedPaths());
        ls.add(columnExcludedPaths());
        ls.add(columnIncludedDocPaths());
        ls.add(columnExcludedDocPaths());
        ls.add(columnDepth());
        ls.add(columnMaxAccessCount());
        ls.add(columnNumOfThread());
        ls.add(columnIntervalTime());
        ls.add(columnBoost());
        ls.add(columnAvailable());
        ls.add(columnSortOrder());
        ls.add(columnCreatedBy());
        ls.add(columnCreatedTime());
        ls.add(columnUpdatedBy());
        ls.add(columnUpdatedTime());
        ls.add(columnDeletedBy());
        ls.add(columnDeletedTime());
        ls.add(columnVersionNo());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    @Override
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    @Override
    public boolean hasPrimaryKey() {
        return true;
    }

    @Override
    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------
    public ReferrerInfo referrerFailureUrlList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FailureUrlDbm.getInstance().columnFileConfigId());
        return cri("failureUrlList", this, FailureUrlDbm.getInstance(), map,
                false);
    }

    public ReferrerInfo referrerFileAuthenticationList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FileAuthenticationDbm.getInstance()
                        .columnFileCrawlingConfigId());
        return cri("fileAuthenticationList", this,
                FileAuthenticationDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerFileConfigToBrowserTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FileConfigToBrowserTypeMappingDbm.getInstance()
                        .columnFileConfigId());
        return cri("fileConfigToBrowserTypeMappingList", this,
                FileConfigToBrowserTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerFileConfigToLabelTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FileConfigToLabelTypeMappingDbm.getInstance()
                        .columnFileConfigId());
        return cri("fileConfigToLabelTypeMappingList", this,
                FileConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerFileConfigToRoleTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FileConfigToRoleTypeMappingDbm.getInstance()
                        .columnFileConfigId());
        return cri("fileConfigToRoleTypeMappingList", this,
                FileConfigToRoleTypeMappingDbm.getInstance(), map, false);
    }

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    @Override
    public boolean hasIdentity() {
        return true;
    }

    @Override
    public boolean hasVersionNo() {
        return true;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    @Override
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.FileCrawlingConfig";
    }

    @Override
    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.FileCrawlingConfigCB";
    }

    @Override
    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.FileCrawlingConfigDao";
    }

    @Override
    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.FileCrawlingConfigBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    @Override
    public Class<FileCrawlingConfig> getEntityType() {
        return FileCrawlingConfig.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    public FileCrawlingConfig newMyEntity() {
        return new FileCrawlingConfig();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    @Override
    public void acceptPrimaryKeyMap(final Entity e,
            final Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((FileCrawlingConfig) e, m, _epsMap);
    }

    @Override
    public Map<String, Object> extractPrimaryKeyMap(final Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    @Override
    public Map<String, Object> extractAllColumnMap(final Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<FileCrawlingConfig>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsName(), columnName());
        setupEps(_epsMap, new EpsPaths(), columnPaths());
        setupEps(_epsMap, new EpsIncludedPaths(), columnIncludedPaths());
        setupEps(_epsMap, new EpsExcludedPaths(), columnExcludedPaths());
        setupEps(_epsMap, new EpsIncludedDocPaths(), columnIncludedDocPaths());
        setupEps(_epsMap, new EpsExcludedDocPaths(), columnExcludedDocPaths());
        setupEps(_epsMap, new EpsDepth(), columnDepth());
        setupEps(_epsMap, new EpsMaxAccessCount(), columnMaxAccessCount());
        setupEps(_epsMap, new EpsNumOfThread(), columnNumOfThread());
        setupEps(_epsMap, new EpsIntervalTime(), columnIntervalTime());
        setupEps(_epsMap, new EpsBoost(), columnBoost());
        setupEps(_epsMap, new EpsAvailable(), columnAvailable());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    @Override
    public boolean hasEntityPropertySetupper(final String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    @Override
    public void setupEntityProperty(final String propertyName,
            final Object entity, final Object value) {
        findEps(_epsMap, propertyName)
                .setup((FileCrawlingConfig) entity, value);
    }

    public class EpsId implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsName implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setName((String) v);
        }
    }

    public static class EpsPaths implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setPaths((String) v);
        }
    }

    public static class EpsIncludedPaths implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setIncludedPaths((String) v);
        }
    }

    public static class EpsExcludedPaths implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setExcludedPaths((String) v);
        }
    }

    public static class EpsIncludedDocPaths implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setIncludedDocPaths((String) v);
        }
    }

    public static class EpsExcludedDocPaths implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setExcludedDocPaths((String) v);
        }
    }

    public class EpsDepth implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setDepth(cti(v));
        }
    }

    public class EpsMaxAccessCount implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setMaxAccessCount(ctl(v));
        }
    }

    public class EpsNumOfThread implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setNumOfThread(cti(v));
        }
    }

    public class EpsIntervalTime implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setIntervalTime(cti(v));
        }
    }

    public class EpsBoost implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setBoost(ctb(v));
        }
    }

    public static class EpsAvailable implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setAvailable((String) v);
        }
    }

    public class EpsSortOrder implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setSortOrder(cti(v));
        }
    }

    public static class EpsCreatedBy implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public class EpsVersionNo implements Eps<FileCrawlingConfig> {
        @Override
        public void setup(final FileCrawlingConfig e, final Object v) {
            e.setVersionNo(cti(v));
        }
    }
}
