/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.taglib;

import java.util.Date;
import java.util.List;

import jp.sf.fess.helper.HotSearchWordHelper;
import jp.sf.fess.helper.HotSearchWordHelper.Range;

import org.seasar.framework.container.SingletonS2Container;

public class FessFunctions {
    public static List<String> hsw(String value, Integer size) {
        Range range;
        if (value == null) {
            range = Range.ENTIRE;
        } else if (value.equals("day") || value.equals("1")) {
            range = Range.ONE_DAY;
        } else if (value.equals("week") || value.equals("7")) {
            range = Range.ONE_DAY;
        } else if (value.equals("month") || value.equals("30")) {
            range = Range.ONE_DAY;
        } else if (value.equals("year") || value.equals("365")) {
            range = Range.ONE_DAY;
        } else {
            range = Range.ENTIRE;
        }

        HotSearchWordHelper hotSearchWordHelper = SingletonS2Container
                .getComponent(HotSearchWordHelper.class);
        List<String> wordList = hotSearchWordHelper.getHotSearchWordList(range);
        if (wordList.size() > size) {
            return wordList.subList(0, size);
        }
        return wordList;
    }

    public static Integer hswsize(String value) {
        Range range;
        if (value == null) {
            range = Range.ENTIRE;
        } else if (value.equals("day") || value.equals("1")) {
            range = Range.ONE_DAY;
        } else if (value.equals("week") || value.equals("7")) {
            range = Range.ONE_DAY;
        } else if (value.equals("month") || value.equals("30")) {
            range = Range.ONE_DAY;
        } else if (value.equals("year") || value.equals("365")) {
            range = Range.ONE_DAY;
        } else {
            range = Range.ENTIRE;
        }

        HotSearchWordHelper hotSearchWordHelper = SingletonS2Container
                .getComponent(HotSearchWordHelper.class);
        return hotSearchWordHelper.getHotSearchWordList(range).size();
    }

    public static Date date(Long value) {
        if (value == null) {
            return null;
        }
        return new Date(value.longValue());
    }
}
