/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.helper;

import jp.sf.fess.entity.SearchQuery;

public interface QueryHelper {

    SearchQuery build(String query);

    SearchQuery build(String query, boolean envCondition);

    String[] getResponseFields();

    String[] getHighlightingFields();

    int getHighlightSnippetSize();

    String getShards();

    boolean isFacetField(String f);

    String buildFacetQuery(String query);

    boolean isFacetSortValue(String sort);
}