/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of DATA_CONFIG_TO_LABEL_TYPE_MAPPING. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class DataConfigToLabelTypeMappingDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final DataConfigToLabelTypeMappingDbm _instance = new DataConfigToLabelTypeMappingDbm();

    private DataConfigToLabelTypeMappingDbm() {
    }

    public static DataConfigToLabelTypeMappingDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";

    protected final String _tablePropertyName = "dataConfigToLabelTypeMapping";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "DATA_CONFIG_TO_LABEL_TYPE_MAPPING", _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, null, true,
            "id", Long.class, true, true, "BIGINT", 19, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnDataConfigId = cci("DATA_CONFIG_ID",
            "DATA_CONFIG_ID", null, null, true, "dataConfigId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null,
            "dataCrawlingConfig", null, null);

    protected final ColumnInfo _columnLabelTypeId = cci("LABEL_TYPE_ID",
            "LABEL_TYPE_ID", null, null, true, "labelTypeId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null, "labelType",
            null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnDataConfigId() {
        return _columnDataConfigId;
    }

    public ColumnInfo columnLabelTypeId() {
        return _columnLabelTypeId;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnDataConfigId());
        ls.add(columnLabelTypeId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignDataCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnDataConfigId(), DataCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("dataCrawlingConfig", this,
                DataCrawlingConfigDbm.getInstance(), map, 0, false, false);
    }

    public ForeignInfo foreignLabelType() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnLabelTypeId(),
                LabelTypeDbm.getInstance().columnId());
        return cfi("labelType", this, LabelTypeDbm.getInstance(), map, 1,
                false, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.DataConfigToLabelTypeMappingCB";
    }

    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.DataConfigToLabelTypeMappingDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<DataConfigToLabelTypeMapping> getEntityType() {
        return DataConfigToLabelTypeMapping.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public DataConfigToLabelTypeMapping newMyEntity() {
        return new DataConfigToLabelTypeMapping();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((DataConfigToLabelTypeMapping) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<DataConfigToLabelTypeMapping>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsDataConfigId(), columnDataConfigId());
        setupEps(_epsMap, new EpsLabelTypeId(), columnLabelTypeId());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup(
                (DataConfigToLabelTypeMapping) entity, value);
    }

    public class EpsId implements Eps<DataConfigToLabelTypeMapping> {
        public void setup(DataConfigToLabelTypeMapping e, Object v) {
            e.setId(ctl(v));
        }
    }

    public class EpsDataConfigId implements Eps<DataConfigToLabelTypeMapping> {
        public void setup(DataConfigToLabelTypeMapping e, Object v) {
            e.setDataConfigId(ctl(v));
        }
    }

    public class EpsLabelTypeId implements Eps<DataConfigToLabelTypeMapping> {
        public void setup(DataConfigToLabelTypeMapping e, Object v) {
            e.setLabelTypeId(ctl(v));
        }
    }
}
