/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of WEB_CONFIG_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     ROLE_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     roleType, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToRoleTypeMappingDbm getMyDBMeta() {
        return WebConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebConfigToRoleTypeMapping newMyEntity() {
        return new WebConfigToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebConfigToRoleTypeMappingCB newMyConditionBean() {
        return new WebConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebConfigToRoleTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(WebConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebConfigToRoleTypeMapping&gt;() {
     *     public void handle(WebConfigToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(WebConfigToRoleTypeMappingCB cb,
            EntityRowHandler<WebConfigToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> void doSelectCursor(
            WebConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webConfigToRoleTypeMapping != null) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectEntity(
            WebConfigToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectEntity(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webConfigToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            WebConfigToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebConfigToRoleTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebConfigToRoleTypeMapping&gt; webConfigToRoleTypeMappingList = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebConfigToRoleTypeMapping webConfigToRoleTypeMapping : webConfigToRoleTypeMappingList) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebConfigToRoleTypeMapping> selectList(
            WebConfigToRoleTypeMappingCB cb) {
        return doSelectList(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            WebConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebConfigToRoleTypeMapping&gt; page = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebConfigToRoleTypeMapping webConfigToRoleTypeMapping : page) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebConfigToRoleTypeMapping> selectPage(
            WebConfigToRoleTypeMappingCB cb) {
        return doSelectPage(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            WebConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    public int callbackSelectCount(
                            WebConfigToRoleTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebConfigToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param webConfigToRoleTypeMappingList The list of webConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                webConfigToRoleTypeMappingList,
                new InternalPulloutCallback<WebConfigToRoleTypeMapping, RoleType>() {
                    public RoleType getFr(WebConfigToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(RoleType e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToRoleTypeMappingList The list of webConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                webConfigToRoleTypeMappingList,
                new InternalPulloutCallback<WebConfigToRoleTypeMapping, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(WebConfigToRoleTypeMapping e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToRoleTypeMapping.setFoo...(value);
     * webConfigToRoleTypeMapping.setBar...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(webConfigToRoleTypeMapping);
     * ... = webConfigToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        assertEntityNotNull(webConfigToRoleTypeMapping);
        delegateInsert(webConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(webConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        helpUpdateInternally(webConfigToRoleTypeMapping,
                new InternalUpdateCallback<WebConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                webConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB>() {
                    public void callbackInsert(WebConfigToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(WebConfigToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public WebConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            WebConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(webConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        helpDeleteInternally(webConfigToRoleTypeMapping,
                new InternalDeleteCallback<WebConfigToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            WebConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        return delegateInsertList(webConfigToRoleTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        return delegateUpdateList(webConfigToRoleTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        return delegateDeleteList(webConfigToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setPK...(value);</span>
     * webConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setVersionNo(value);</span>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(webConfigToRoleTypeMapping, cb);
     * </pre>
     * @param webConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            WebConfigToRoleTypeMappingCB cb) {
        return delegateQueryUpdate(webConfigToRoleTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(webConfigToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebConfigToRoleTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *         public void specify(WebConfigToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(webConfigToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(webConfigToRoleTypeMapping,
                new InternalUpdateCallback<WebConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToRoleTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setPK...(value);</span>
     * webConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setVersionNo(value);</span>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void specify(WebConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webConfigToRoleTypeMapping, cb, option);
     * </pre>
     * @param webConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            WebConfigToRoleTypeMappingCB cb,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(webConfigToRoleTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> void delegateSelectCursor(
            WebConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> List<ENTITY> delegateSelectList(
            WebConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebConfigToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(WebConfigToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(WebConfigToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<WebConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<WebConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(WebConfigToRoleTypeMapping e,
            WebConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(WebConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(WebConfigToRoleTypeMapping e,
            UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(WebConfigToRoleTypeMapping e,
            WebConfigToRoleTypeMappingCB cb,
            UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebConfigToRoleTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                WebConfigToRoleTypeMapping.class);
    }

    protected WebConfigToRoleTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebConfigToRoleTypeMappingCB.class);
    }
}
