/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.exentity.FailureUrl;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of FAILURE_URL. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class FailureUrlDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final FailureUrlDbm _instance = new FailureUrlDbm();

    private FailureUrlDbm() {
    }

    public static FailureUrlDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "FAILURE_URL";

    protected final String _tablePropertyName = "failureUrl";

    protected final TableSqlName _tableSqlName = new TableSqlName("FAILURE_URL");

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, true, "id",
            Long.class, true, true, "BIGINT", 19, 0, false, null, null, null,
            null, null);

    protected final ColumnInfo _columnUrl = cci("URL", "URL", null, true,
            "url", String.class, false, false, "VARCHAR", 4000, 0, false, null,
            null, null, null, null);

    protected final ColumnInfo _columnThreadName = cci("THREAD_NAME",
            "THREAD_NAME", null, true, "threadName", String.class, false,
            false, "VARCHAR", 30, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorName = cci("ERROR_NAME",
            "ERROR_NAME", null, false, "errorName", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorLog = cci("ERROR_LOG", "ERROR_LOG",
            null, false, "errorLog", String.class, false, false, "VARCHAR",
            4000, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorCount = cci("ERROR_COUNT",
            "ERROR_COUNT", null, true, "errorCount", Integer.class, false,
            false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnLastAccessTime = cci("LAST_ACCESS_TIME",
            "LAST_ACCESS_TIME", null, true, "lastAccessTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnWebConfigId = cci("WEB_CONFIG_ID",
            "WEB_CONFIG_ID", null, false, "webConfigId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "webCrawlingConfig",
            null, null);

    protected final ColumnInfo _columnFileConfigId = cci("FILE_CONFIG_ID",
            "FILE_CONFIG_ID", null, false, "fileConfigId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "fileCrawlingConfig",
            null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnUrl() {
        return _columnUrl;
    }

    public ColumnInfo columnThreadName() {
        return _columnThreadName;
    }

    public ColumnInfo columnErrorName() {
        return _columnErrorName;
    }

    public ColumnInfo columnErrorLog() {
        return _columnErrorLog;
    }

    public ColumnInfo columnErrorCount() {
        return _columnErrorCount;
    }

    public ColumnInfo columnLastAccessTime() {
        return _columnLastAccessTime;
    }

    public ColumnInfo columnWebConfigId() {
        return _columnWebConfigId;
    }

    public ColumnInfo columnFileConfigId() {
        return _columnFileConfigId;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnUrl());
        ls.add(columnThreadName());
        ls.add(columnErrorName());
        ls.add(columnErrorLog());
        ls.add(columnErrorCount());
        ls.add(columnLastAccessTime());
        ls.add(columnWebConfigId());
        ls.add(columnFileConfigId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignFileCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnFileConfigId(), FileCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("fileCrawlingConfig", this,
                FileCrawlingConfigDbm.getInstance(), map, 0, false);
    }

    public ForeignInfo foreignWebCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnWebConfigId(),
                WebCrawlingConfigDbm.getInstance().columnId());
        return cfi("webCrawlingConfig", this,
                WebCrawlingConfigDbm.getInstance(), map, 1, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.FailureUrl";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.FailureUrlCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.FailureUrlDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.FailureUrlBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<FailureUrl> getEntityType() {
        return FailureUrl.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public FailureUrl newMyEntity() {
        return new FailureUrl();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((FailureUrl) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<FailureUrl>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsUrl(), columnUrl());
        setupEps(_epsMap, new EpsThreadName(), columnThreadName());
        setupEps(_epsMap, new EpsErrorName(), columnErrorName());
        setupEps(_epsMap, new EpsErrorLog(), columnErrorLog());
        setupEps(_epsMap, new EpsErrorCount(), columnErrorCount());
        setupEps(_epsMap, new EpsLastAccessTime(), columnLastAccessTime());
        setupEps(_epsMap, new EpsWebConfigId(), columnWebConfigId());
        setupEps(_epsMap, new EpsFileConfigId(), columnFileConfigId());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((FailureUrl) entity, value);
    }

    public class EpsId implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsUrl implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setUrl((String) v);
        }
    }

    public static class EpsThreadName implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setThreadName((String) v);
        }
    }

    public static class EpsErrorName implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setErrorName((String) v);
        }
    }

    public static class EpsErrorLog implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setErrorLog((String) v);
        }
    }

    public class EpsErrorCount implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setErrorCount(cti(v));
        }
    }

    public static class EpsLastAccessTime implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setLastAccessTime((java.sql.Timestamp) v);
        }
    }

    public class EpsWebConfigId implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setWebConfigId(ctl(v));
        }
    }

    public class EpsFileConfigId implements Eps<FailureUrl> {
        public void setup(FailureUrl e, Object v) {
            e.setFileConfigId(ctl(v));
        }
    }
}
