package jp.sf.fess.ds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataStoreFactory {
    protected Map<String, DataStore> dataStoreMap = new LinkedHashMap<String, DataStore>();

    public void add(String name, DataStore dataStore) {
        if (name == null || dataStore == null) {
            throw new IllegalArgumentException("name or dataStore is null.");
        }
        dataStoreMap.put(name, dataStore);
    }

    public DataStore getDataStore(String name) {
        return dataStoreMap.get(name);
    }

    public List<String> getDataStoreNameList() {
        Set<String> nameSet = dataStoreMap.keySet();
        List<String> nameList = new ArrayList<String>();
        nameList.addAll(nameSet);
        return nameList;
    }

}
