/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of ROLE_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class BsRoleTypeCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected RoleTypeCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "ROLE_TYPE";
    }

    public String getTableSqlName() {
        return "ROLE_TYPE";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public RoleTypeCQ query() {
        return getConditionQuery();
    }

    public RoleTypeCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new RoleTypeCQ(null, getSqlClause(),
                    getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<RoleTypeCB> unionQuery) {
        final RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final RoleTypeCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;RoleTypeCB&gt;() {
     *     public void query(RoleTypeCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<RoleTypeCB> unionQuery) {
        final RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final RoleTypeCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<RoleTypeCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public RoleTypeCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends AbstractSpecification<RoleTypeCQ> {
        protected SpQyCall<RoleTypeCQ> _myQyCall;

        public Specification(ConditionBean baseCB, SpQyCall<RoleTypeCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnName() {
            doColumn("NAME");
        }

        public void columnValue() {
            doColumn("VALUE");
        }

        public void columnSortOrder() {
            doColumn("SORT_ORDER");
        }

        public void columnCreatedBy() {
            doColumn("CREATED_BY");
        }

        public void columnCreatedTime() {
            doColumn("CREATED_TIME");
        }

        public void columnUpdatedBy() {
            doColumn("UPDATED_BY");
        }

        public void columnUpdatedTime() {
            doColumn("UPDATED_TIME");
        }

        public void columnDeletedBy() {
            doColumn("DELETED_BY");
        }

        public void columnDeletedTime() {
            doColumn("DELETED_TIME");
        }

        public void columnVersionNo() {
            doColumn("VERSION_NO");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
        }

        protected String getTableDbName() {
            return "ROLE_TYPE";
        }

        public RAFunction<DataConfigToRoleTypeMappingCB, RoleTypeCQ> derivedDataConfigToRoleTypeMappingList() {
            return new RAFunction<DataConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<DataConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<DataConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveDataConfigToRoleTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        public RAFunction<FileConfigToRoleTypeMappingCB, RoleTypeCQ> derivedFileConfigToRoleTypeMappingList() {
            return new RAFunction<FileConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<FileConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<FileConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveFileConfigToRoleTypeMappingList(
                                    function, subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }

        public RAFunction<WebConfigToRoleTypeMappingCB, RoleTypeCQ> derivedWebConfigToRoleTypeMappingList() {
            return new RAFunction<WebConfigToRoleTypeMappingCB, RoleTypeCQ>(
                    _baseCB,
                    _myQyCall.qy(),
                    new RAQSetupper<WebConfigToRoleTypeMappingCB, RoleTypeCQ>() {
                        public void setup(
                                String function,
                                SubQuery<WebConfigToRoleTypeMappingCB> subQuery,
                                RoleTypeCQ cq, String aliasName) {
                            cq.xsderiveWebConfigToRoleTypeMappingList(function,
                                    subQuery, aliasName);
                        }
                    }, _dbmetaProvider);
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return RoleTypeCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return RoleTypeCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
