/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess;

public class Constants {
    public static final String LOGIN_INFO = "jp.sf.fess.LoginInfo";

    public static final String EMPTY_STRING = "";

    public static final String TRUE = "true";

    public static final String FALSE = "false";

    public static final String T = "T";

    public static final String F = "F";

    public static final String ITEM_LABEL = "label";

    public static final String ITEM_VALUE = "value";

    public static final String UTF_8 = "UTF-8";

    public static final String STANDARD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 * * ?";

    public static final int DEFAULT_INTERVAL_TIME_FOR_FS = 500;

    public static final int DEFAULT_INTERVAL_TIME_FOR_WEB = 5000;

    public static final int DEFAULT_NUM_OF_THREAD_FOR_FS = 10;

    public static final int DEFAULT_NUM_OF_THREAD_FOR_WEB = 5;

    /** Solr Status: Active */
    public static final String ACTIVE = "ACTIVE";

    /** Solr Status: Inactive */
    public static final String INACTIVE = "INACTIVE";

    public static final String GOOGLE_MOBILE_TRANSCODER = "google";

    // solr properties

    public static final String CURRENT_SERVER_FOR_UPDATE = "current.server.for.update";

    public static final String CURRENT_SERVER_FOR_SELECT = "current.server.for.select";

    // fess properties

    public static final String MULTIPROCESS_CRAWLING_PROPERTY = "multiprocess.crawling";

    public static final String CRON_EXPRESSION_PROPERTY = "cron.expression";

    public static final String DAY_FOR_CLEANUP_PROPERTY = "day.for.cleanup";

    public static final String OPTIMIZE_PROPERTY = "optimize.index";

    public static final String COMMIT_PROPERTY = "commit.index";

    public static final String SERVER_ROTATION_PROPERTY = "server.rotation";

    public static final String MOBILE_TRANSCODER_PROPERTY = "mobile.transcoder";

    public static final String AUTH_CIPHER = "jp.sf.fess.AuthCipher";

    public static final String RETURN_PATH = "jp.sf.fess.ReturnPath";

    public static final String QUERIES = "jp.sf.fess.Queries";

    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static final int DONE_STATUS = 9999;

    // info map

    public static final String CRAWLER_START_TIME = "CrawlerStartTime";

    public static final String CRAWLER_END_TIME = "CrawlerEndTime";

    public static final String CRAWLER_EXEC_TIME = "CrawlerExecTime";

    public static final String WEB_CRAWLER_START_TIME = "WebCrawlerStartTime";

    public static final String WEB_CRAWLER_END_TIME = "WebCrawlerEndTime";

    public static final String FS_CRAWLER_START_TIME = "FsCrawlerStartTime";

    public static final String FS_CRAWLER_END_TIME = "FsCrawlerEndTime";

    public static final String OPTIMIZE_START_TIME = "OptimizeStartTime";

    public static final String OPTIMIZE_END_TIME = "OptimizeEndTime";

    public static final String OPTIMIZE_EXEC_TIME = "OptimizeExecTime";

    public static final String COMMIT_START_TIME = "CommitStartTime";

    public static final String COMMIT_END_TIME = "CommitEndTime";

    public static final String COMMIT_EXEC_TIME = "CommitExecTime";

    public static final String WEB_CRAWLING_EXEC_TIME = "WebCrawlExecTime";

    public static final String WEB_INDEX_EXEC_TIME = "WebIndexExecTime";

    public static final String WEB_INDEX_SIZE = "WebIndexSize";

    public static final String FS_CRAWLING_EXEC_TIME = "FsCrawlExecTime";

    public static final String FS_INDEX_EXEC_TIME = "FsIndexExecTime";

    public static final String FS_INDEX_SIZE = "FsIndexSize";
}
