/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.solr;

import org.seasar.extension.unit.S2TestCase;

public class SolrServerManagerTest extends S2TestCase {

    public SolrServerManager solrServerManager;

    @Override
    protected String getRootDicon() throws Throwable {
        return "app.dicon";
    }

    public void test_addSolrServerGroup() {
        final SolrServerGroup solrServerGroup = new SolrServerGroup();
        solrServerGroup.setGroupName("hoge");

        solrServerManager.addSolrServerGroup(solrServerGroup);

        assertTrue(solrServerManager.solrServerGroupMap
                .containsValue(solrServerGroup));
    }

    public void test_getSelectSolrServerGroup() {
        final SolrServerGroup solrServerGroup = solrServerManager
                .getSelectSolrServerGroup();
        assertEquals("solrGroup1", solrServerManager.selectSolrServerGroupName);
        assertEquals("solrGroup1", solrServerGroup.groupName);
    }

    public void test_getSolrServerGroup_byName() {
        final SolrServerGroup solrServerGroup = solrServerManager
                .getSolrServerGroup("solrGroup2");
        assertNull(solrServerManager.selectSolrServerGroupName);
        assertEquals("solrGroup2", solrServerGroup.groupName);
    }

    public void test_getUpdateSolrServerGroup() {
        final SolrServerGroup solrServerGroup = solrServerManager
                .getUpdateSolrServerGroup();
        assertEquals("solrGroup2", solrServerManager.updateSolrServerGroupName);
        assertEquals("solrGroup2", solrServerGroup.groupName);
    }

    public void test_getSolrServerNames() {
        final String[] serverNames = solrServerManager.getSolrServerNames();
        assertEquals(2, serverNames.length);
    }
}
