<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.system_title_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="system" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

	<div>
		<html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages>
		<html:errors/>
	</div>

	<s:form>
	<div class="form-table">
		<table style="width:500px;">
            <caption><bean:message key="labels.system_title_edit"/></caption>
			<tbody>
				<tr>
					<th style="width:200px;">
						<bean:message key="labels.solr_process_running"/>
					</th>
					<td>
						<c:if test="${solrProcessRunning}"><bean:message key="labels.solr_running"/>
						<c:if test="${runningSessionId!=null}">(${f:h(runningSessionId)})</c:if>
						</c:if>
						<c:if test="${!solrProcessRunning}"><bean:message key="labels.solr_stopped"/></c:if>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<c:if test="${solrProcessRunning}"><input type="submit" name="stop" value="<bean:message key="labels.solr_button_stop"/>"/></c:if>
						<c:if test="${!solrProcessRunning}"><input type="submit" name="start" value="<bean:message key="labels.solr_button_start"/>"/></c:if>
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
	</s:form>

	<s:form>
	<div class="form-table" style="margin-top:5px;">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_title_edit"/></caption>
			<tbody>
				<tr>
					<th>
						<bean:message key="labels.solr_current_select_server"/>
					</th>
					<td>
						${f:h(currentServerForSelect)}
						(<c:if test="${currentServerStatusForSelect=='ACTIVE'}"><bean:message key="labels.solr_active"/></c:if><c:if test="${currentServerStatusForSelect!='ACTIVE'}"><bean:message key="labels.solr_inactive"/></c:if>)
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.solr_current_update_server"/>
					</th>
					<td>
						${f:h(currentServerForUpdate)}
						(<c:if test="${currentServerStatusForUpdate=='ACTIVE'}"><bean:message key="labels.solr_active"/></c:if><c:if test="${currentServerStatusForUpdate!='ACTIVE'}"><bean:message key="labels.solr_inactive"/></c:if>)
					</td>
				</tr>
			<c:forEach var="serverStatus" items="${serverStatusList}">
				<tr>
					<th style="width:200px;">
					${f:h(serverStatus.serverName)}
					</th>
					<td>
					<html:select name="serverStatusList" property="${serverStatus.serverName}" value="${serverStatus.status}" indexed="true">
						<html:option value="ACTIVE"><bean:message key="labels.solr_active"/></html:option>
						<html:option value="INACTIVE"><bean:message key="labels.solr_inactive"/></html:option>
						<html:option value="CORRUPTED"><bean:message key="labels.solr_corrupted"/></html:option>
					</html:select>
					</td>
				</tr>
			</c:forEach>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" name="update" value="<bean:message key="labels.solr_button_update"/>"/>
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
	</s:form>

	<div class="form-table" style="margin-top:5px;">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_title_action"/></caption>
			<tbody>
			<c:forEach var="groupAction" items="${groupActionItems}">
				<tr>
					<td style="padding:0;margin:0;">
				<s:form style="margin:0;padding:0;">
				<table style="width:100%;">
				<tr>
					<th style="width:150px;" rowspan="3">
					${f:h(groupAction.groupName)}
					</th>
					<td>
					<html:hidden property="groupName" value="${f:u(groupAction.groupName)}"/>
					<html:submit property="commit" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_commit"/></html:submit>
					<html:submit property="optimize" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_optimize"/></html:submit>
					</td>
				</tr>
				<tr>
					<td>
					<html:select property="sessionId" disabled="${solrProcessRunning}">
						<html:option value=""><bean:message key="labels.solr_action_none"/></html:option>
						<c:forEach var="sessionIdItem" items="${groupAction.sessionIdItems}">
							<html:option value="${f:u(sessionIdItem.value)}">${f:h(sessionIdItem.label)}</html:option>
						</c:forEach>
						<html:option value="*"><bean:message key="labels.solr_action_all"/> (${f:h(groupAction.totalCount)})</html:option>
					</html:select>
					<html:submit property="delete" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_delete"/></html:submit>
					</td>
				</tr>
				<tr>
					<td>
					<bean:message key="labels.solr_action_url_delete"/>
					<html:text property="deleteUrl" style="width:150px;" disabled="${solrProcessRunning}"></html:text>
					<html:submit property="confirmByUrl" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_confirm_list"/></html:submit>
					<html:submit property="deleteByUrl" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_delete"/></html:submit>
					</td>
				</tr>
				</table>
				</s:form>
					</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
	</div>

	<div class="form-table" style="margin-top:5px;">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_management_title"/></caption>
			<tbody>
				<tr>
					<th style="width:200px;">
						<bean:message key="labels.solr_instance_name"/>
					</th>
					<th style="width:100px;">
						<bean:message key="labels.solr_instance_status"/>
					</th>
					<th>
						<bean:message key="labels.solr_instance_action"/>
					</th>
				</tr>
			<c:forEach var="solrInstance" items="${solrInstanceList}">
				<tr>
					<td>
					${f:h(solrInstance.name)}
					</td>
					<td style="text-align: center;">
					${f:h(solrInstance.status)}
					</td>
					<td style="text-align: center;">
					<s:form>
					<input type="hidden" name="solrInstanceName" value="${f:h(solrInstance.name)}"/>
					<c:if test="${solrInstance.status!='running'}">
					<html:submit property="startSolrInstance" disabled="${solrProcessRunning}"><bean:message key="labels.solr_instance_start"/></html:submit>
					</c:if><c:if test="${solrInstance.status=='running'}">
					<html:submit property="stopSolrInstance" disabled="${solrProcessRunning}"><bean:message key="labels.solr_instance_stop"/></html:submit>
					<html:submit property="reloadSolrInstance" disabled="${solrProcessRunning}"><bean:message key="labels.solr_instance_reload"/></html:submit>
					</c:if>
					</s:form>
					</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
	</div>

	<div class="form-table" style="margin-top:5px;">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_document_title"/></caption>
            <thead>
            	<tr>
            		<th><bean:message key="labels.solr_group_name"/></th>
            		<th><bean:message key="labels.session_name"/></th>
            		<th><bean:message key="labels.solr_num_of_docs"/></th>
            	</tr>
            </thead>
			<tbody>
			<c:forEach var="groupAction" items="${groupActionItems}">
				<tr>
					<td>${f:h(groupAction.groupName)}</td>
					<td align="center"><bean:message key="labels.system_document_all"/></td>
					<td align="center">${f:h(groupAction.totalCount)}</td>
				</tr>
			</c:forEach>
			<c:forEach var="groupAction" items="${groupActionItems}">
				<c:forEach var="sessionIdItem" items="${groupAction.sessionIdItems}">
				<tr>
					<td>${f:h(groupAction.groupName)}</td>
					<td align="center"><html:link href="${f:url('/admin/searchList/search')}?query=segment:${f:u(sessionIdItem.value)}">${f:h(sessionIdItem.value)}</html:link></td>
					<td align="center">${f:h(sessionIdItem.count)}</td>
				</tr>
				</c:forEach>
			</c:forEach>
			</tbody>
		</table>
	</div>

      </div>
<c:if test="${solrProcessRunning}">
<script type="text/javascript">
<!--
setTimeout(function(){
	window.location.reload();
}, 15000);
//-->
</script>
</c:if>
	</tiles:put>
</tiles:insert>
