/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.ciq.LabelTypeCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of LABEL_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class BsLabelTypeCQ extends AbstractBsLabelTypeCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected LabelTypeCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsLabelTypeCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from LABEL_TYPE) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public LabelTypeCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new LabelTypeCIQ(getChildQuery(), getSqlClause(),
                    getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join LABEL_TYPE on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public LabelTypeCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        LabelTypeCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_InScopeSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_InScopeSubQuery_FileConfigToLabelTypeMappingList() {
        return _id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap == null) {
            _id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_FileConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_InScopeSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_NotInScopeSubQuery_FileConfigToLabelTypeMappingList() {
        return _id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_FileConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_ExistsSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_ExistsSubQuery_FileConfigToLabelTypeMappingList() {
        return _id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap == null) {
            _id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_FileConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_ExistsSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_NotExistsSubQuery_DataConfigToLabelTypeMappingList() {
        return _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap == null) {
            _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_DataConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_NotExistsSubQuery_FileConfigToLabelTypeMappingList() {
        return _id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap == null) {
            _id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_FileConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_NotExistsSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList() {
        return _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingList() {
        return _id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, DataConfigToLabelTypeMappingCQ> _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getId_QueryDerivedReferrer_DataConfigToLabelTypeMappingList() {
        return _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_DataConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter."
                + key;
    }

    protected Map<String, FileConfigToLabelTypeMappingCQ> _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap;

    public Map<String, FileConfigToLabelTypeMappingCQ> getId_QueryDerivedReferrer_FileConfigToLabelTypeMappingList() {
        return _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_FileConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameter."
                + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter."
                + key;
    }

    public BsLabelTypeCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    public BsLabelTypeCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _value;

    public ConditionValue getValue() {
        if (_value == null) {
            _value = nCV();
        }
        return _value;
    }

    protected ConditionValue getCValueValue() {
        return getValue();
    }

    public BsLabelTypeCQ addOrderBy_Value_Asc() {
        regOBA("VALUE");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_Value_Desc() {
        regOBD("VALUE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsLabelTypeCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsLabelTypeCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsLabelTypeCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsLabelTypeCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsLabelTypeCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsLabelTypeCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsLabelTypeCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsLabelTypeCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsLabelTypeCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsLabelTypeCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsLabelTypeCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, LabelTypeCQ> _scalarSubQueryMap;

    public Map<String, LabelTypeCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(LabelTypeCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, LabelTypeCQ> _myselfInScopeSubQueryMap;

    public Map<String, LabelTypeCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(LabelTypeCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return LabelTypeCB.class.getName();
    }

    String xCQ() {
        return LabelTypeCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
