package jp.sourceforge.dvibrowser.dvicore.image.pnm;
/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.InputStream;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviRect;
import jp.sourceforge.dvibrowser.dvicore.DviSize;
import jp.sourceforge.dvibrowser.dvicore.image.split.SplitImageWriter;

public class PpmSplitter
extends AbstractPnmSplitter
{
//  private static final Logger LOGGER = Logger.getLogger(PpmSplitter.class
//      .getName());
  public PpmSplitter(DviSize unitSize, SplitImageWriter imageWriter)
  {
    super(unitSize, imageWriter);
  }
  
  private final int [] table = new int[256];
  
  @Override
  public void beginSplitInternal(PnmHeader header, InputStream is) throws DviException
  {
    super.beginSplitInternal(header, is);
    int maxval = header.getMaxValue();
    for (int i=0; i<256; i++) {
      table[i] = Math.max(Math.min(i * maxval / 255, maxval), 0);
    }
  }
  
  @Override
  protected byte [] createLineBuffer()
  {
    return new byte [header.getWidth() * 3];
  }
  
  @Override
  protected BufferedImage createBufferedImage(DviRect box)
  {
    return new BufferedImage(box.width(), box.height(), BufferedImage.TYPE_3BYTE_BGR);
  }
  
  @Override
  protected int copyLineToDataBuffer(byte [] buf, int x, DviRect box, int i, DataBufferByte data)
  {
    final int w = box.width();
    final int uw = w * 3;
    final byte [] dst = data.getData();
    for (int j=0; j<w; j++) {
      dst[j * 3 + i * uw + 0] = (byte) table[byteToInt(buf[x + j * 3 + 2])]; // B
      dst[j * 3 + i * uw + 1] = (byte) table[byteToInt(buf[x + j * 3 + 1])]; // G
      dst[j * 3 + i * uw + 2] = (byte) table[byteToInt(buf[x + j * 3 + 0])]; // R
    }
    return uw;
  }

  private int byteToInt(byte b) {
    if (b >= 0) return b;
    return 256 + b;
  }
}
