package jp.sourceforge.dvibrowser.dvicore.image.pnm;
/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;


public class PnmByteAsciiFilter
extends AbstractPnmAsciiFilter
{
  private static final int BUFFER_SIZE = 1024;
  private static final String DELIMS = " \t\r\n";
  
  public PnmByteAsciiFilter(InputStream in) {
    super(in);
  }
  
  protected synchronized byte [] fillBuffer() throws IOException
  {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    String line = reader.readLine();
    if (line == null) {
      throw new IOException("EOF detected while reading the input");
    }
    StringTokenizer st = new StringTokenizer(line, DELIMS);
    while (st.hasMoreTokens() && baos.size() < BUFFER_SIZE) {
      String hex = st.nextToken();
      try {
        int value = Integer.parseInt(hex, 10);
        baos.write(value);
      } catch (NumberFormatException e) {
        throw new IOException("Input value is not a hexadecimal: " + hex);
      }
    }
    if (baos.size() == 0) {
      throw new IOException("EOF detected while reading the input");
    }
    return baos.toByteArray();
  }
}
