package jp.sourceforge.dvibrowser.dvicore.ctx;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

import jp.sourceforge.dvibrowser.dvicore.DviRect;
import jp.sourceforge.dvibrowser.dvicore.api.DviFont;
import jp.sourceforge.dvibrowser.dvicore.api.FullMetrics;
import jp.sourceforge.dvibrowser.dvicore.util.concurrent.CacheEntry;
import jp.sourceforge.dvibrowser.dvicore.util.concurrent.CachedComputer;
import jp.sourceforge.dvibrowser.dvicore.util.concurrent.ThreadedComputer;

public class AsyncComputers {
  private final CachedComputer<String, Collection<URL>> dviResourceComputer;
  private final CachedComputer<String, Collection<DviFont>> dviFontComputer;
  private final CachedComputer<String, Collection<FullMetrics>> fullMetricsComputer;
  private final CachedComputer<String, DviRect> boundingBoxComputer;

  protected final Properties properties;

  public AsyncComputers(Properties prop) {
    this.properties = prop;
    this.dviResourceComputer = new CachedComputer<String, Collection<URL>>(
        new ThreadedComputer<String, Collection<URL>>(1));
    this.dviFontComputer = new CachedComputer<String, Collection<DviFont>>(
        new ThreadedComputer<String, Collection<DviFont>>(1)) {
      @Override
      protected boolean removeEldestEntry(
          Map.Entry<String, CacheEntry<String, Collection<DviFont>>> entry) {
        boolean remove = getCache().size() > 64;
        return remove;
      }
    };

    fullMetricsComputer = new CachedComputer<String, Collection<FullMetrics>>(
        new ThreadedComputer<String, Collection<FullMetrics>>(1));

    boundingBoxComputer = new CachedComputer<String, DviRect>(
        new ThreadedComputer<String, DviRect>(1)) {
      @Override
      protected boolean removeEldestEntry(
          Map.Entry<String, CacheEntry<String, DviRect>> entry) {
        return getCache().size() > 1024;
      }
    };

  }

  public CachedComputer<String, Collection<URL>> getDviResourceComputer() {
    return dviResourceComputer;
  }

  public CachedComputer<String, Collection<DviFont>> getDviFontComputer() {
    return dviFontComputer;
  }

  public CachedComputer<String, Collection<FullMetrics>> getFullMetricsComputer() {
    return fullMetricsComputer;
  }

  public CachedComputer<String, DviRect> getBoundingBoxComputer() {
    return boundingBoxComputer;
  }
}
