﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ds8617
{
    class Gpib : IDisposable
    {
        private AxGPC43044Lib.AxIfxGpibAdv axIfxGpibAdv1 = null;
        private string errorMessage = "";

        public Gpib(AxGPC43044Lib.AxIfxGpibAdv instance)
        {
            errorMessage = "";

            axIfxGpibAdv1 = instance;

            axIfxGpibAdv1.AsyncTransfer = false;
            axIfxGpibAdv1.TransferTimeOut = 50; // 10 00ms

            axIfxGpibAdv1.DeviceAddress1 = 4;
            axIfxGpibAdv1.DeviceName1 = "DS8617";
            axIfxGpibAdv1.SendDelimiter1 = 7; // CRLF + EOI
            axIfxGpibAdv1.RecvDelimiter1 = 7; // CRLF + EOI

            int result;
            result = axIfxGpibAdv1.Open();
            if (result < 0)
                errorMessage += "OpenError:" + result + "\r\n";

            result = axIfxGpibAdv1.SetIfc();
            if (result < 0)
                errorMessage += "IfcError:" + result + "\r\n";

            result = axIfxGpibAdv1.SetRen();
            if (result < 0)
                errorMessage += "RenError:" + result + "\r\n";
        }

        ~Gpib()
        {
            Dispose();
        }

        public void Dispose()
        {
            if (axIfxGpibAdv1 != null)
            {
                axIfxGpibAdv1.Close();
                axIfxGpibAdv1 = null;
            }
        }

        public string ErrorMessage
        {
            get { return errorMessage; }
        }

        /// <summary>
        /// IEEE488.2の浮動小数点フォーマットをfloatに変換する
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static double AnalyzeResponseFloat(string arg)
        {
            // double.parseでもいいけど、一応仕様通りにする

            string str = arg + " "; // インデックスの有効を調べないので無効な文字を追加

            double value = 0;
            bool invert = false;

            int p = 0;

            {
                if (str[p] == '+')
                {
                    ++p;
                    invert = false;
                }
                if (str[p] == '-')
                {
                    ++p;
                    invert = true;
                }
            }

            {
                while (char.IsDigit(str, p))
                {
                    value = value * 10 + (str[p++] - '0');
                }
            }

            if (str[p] == '.')
            {
                ++p;

                double fac = 0.1;

                while (char.IsDigit(str, p))
                {
                    value += (str[p++] - '0') * fac;
                    fac *= 0.1;
                }
            }

            if (str[p] == 'e' || str[p] == 'E')
            {
                ++p;

                double e = 0;
                bool einv = false;

                if (str[p] == '+')
                {
                    ++p;
                    einv = false;
                }
                if (str[p] == '-')
                {
                    ++p;
                    einv = true;
                }

                while (char.IsDigit(str, p))
                {
                    e = e * 10 + (str[p++] - '0');
                }

                if (einv)
                    e = -e;

                value *= Math.Pow(10, e);
            }

            if (invert)
                value = -value;

            return value;
        }
    }
}
