﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ClipClop.Model
{
	public delegate void ActionLogEventHandler(string message);

	public class ActionLogManager
	{
		public class Data
		{
			readonly string msg_;
			readonly DateTime now_;

			public Data(string msg)
			{
				msg_ = msg;
				now_ = DateTime.Now;
			}

			public string[] Item
			{
				get
				{
					string[] ret = new string[2];

					ret[0] = now_.ToString();
					ret[1] = msg_;
					return ret;
				}
			}

			public string Msg { get { return msg_; } }
			public DateTime Time { get { return now_; } }
		}

		List<Data> logContiner_ = new List<Data>();
		readonly int MAX_LOG_ = ClipClop.Properties.Settings.Default.ActionLogMax;

		public event ActionLogEventHandler OnLog;

		public int Count
		{
			get
			{
				return this.logContiner_.Count;
			}
		}

		public enum category
		{
			action,
			script,
		}

		public void Add(category c, string msg)
		{
			string s = string.Format("[{0}] {1}",c.ToString(),msg);
			logContiner_.Add(new Data(s));

			if (this.logContiner_.Count > MAX_LOG_)
			{
				this.logContiner_.RemoveAt(0);
			}

			if (this.OnLog != null)
			{
				this.OnLog(s);
			}
		}

		public Data this[int idx]
		{
			get { return this.logContiner_[idx]; }
		}
	}
}
