﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using CaLib.User;

namespace ClipClop.User
{
    public static class XmlNodeHelper
    {
        public static ContextMenuSettingDefinition.Classification GetClassification(XmlNode node)
        {
            if (ContextMenuSettingDefinition.Sentence_ == node.Name)
            {
                return ContextMenuSettingDefinition.Classification.sentence;
            }

            if (ContextMenuSettingDefinition.Folder_ == node.Name)
            {
                return ContextMenuSettingDefinition.Classification.folder;
            }

            if (ContextMenuSettingDefinition.Root_ == node.Name)
            {
                return ContextMenuSettingDefinition.Classification.root;
            }

            return ContextMenuSettingDefinition.Classification.separator;
        }

        public static ContextMenuSettingDefinition.SentenceType GetSentenceType(XmlNode node)
        {
            if (ContextMenuSettingDefinition.Sentence_ != node.Name)
            {
                throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);
            }

            XmlAttribute attri = node.Attributes[ContextMenuSettingDefinition.Type_];
            if (null == attri)
            {
                throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);
            }

			ContextMenuSettingDefinition.SentenceType sentenceType
                = (ContextMenuSettingDefinition.SentenceType)Enum.Parse(typeof(ContextMenuSettingDefinition.SentenceType), attri.Value);

			return sentenceType;
        }


        public static string GetAttributeValue(XmlNode node, string name)
        {
            XmlAttribute attri = node.Attributes[name];
            if (null != attri)
                return attri.Value;
            return null;
        }

		public static string GetLatterAttribute(XmlNode node)
        {
			XmlAttribute attri = node.Attributes[ContextMenuSettingDefinition.Latter_];
            if (null != attri)
                return attri.Value;
            return null;
        }


        public static string GetDisplayString(ContextMenuSettingDefinition.Classification type, string nameAttribute, string valueAttribute)
        {
            if (ContextMenuSettingDefinition.Classification.sentence == type ||
                ContextMenuSettingDefinition.Classification.folder == type)
            {
                if (string.IsNullOrEmpty(nameAttribute))
                {
                    //Nameがなければ
                    return valueAttribute;
                }
                return nameAttribute;
            }
            return type.ToString();
        }

        public static string GetDisplayString(XmlNode node)
        {
            return GetDisplayString(
                GetClassification(node),
                GetAttributeValue(node, ContextMenuSettingDefinition.Name_),
                GetAttributeValue(node, ContextMenuSettingDefinition.Value_)
               );
        }

        public static string GetDisplayValue(ContextMenuSettingDefinition.Classification type, string valueAttribute)
        {
            if (ContextMenuSettingDefinition.Classification.sentence == type)
            {
                return valueAttribute;
            }
            return string.Empty;
        }

        public static string GetDisplayValue(XmlNode node)
        {
            return GetDisplayValue(
                GetClassification(node),
                GetAttributeValue(node, ContextMenuSettingDefinition.Value_)
               );
        }


		public static XmlElement CreateXmlNodeEx(
			ContextMenuSettingDefinition.Classification classification,
			ContextMenuSettingDefinition.SentenceType sentenceType,
			string nameAttribute,
			string valueAttribute,
			string latterAttribute,
			XmlDocument doc
		)
		{
			XmlElement ret = CreateXmlNode(classification, sentenceType, nameAttribute, valueAttribute, doc);

			if (classification == ContextMenuSettingDefinition.Classification.sentence &&
				sentenceType == ContextMenuSettingDefinition.SentenceType.complex)
			{
				ret.SetAttribute(ContextMenuSettingDefinition.Latter_, latterAttribute);
			}			
			return ret;
		}

        public static XmlElement CreateXmlNode(
            ContextMenuSettingDefinition.Classification type,
            ContextMenuSettingDefinition.SentenceType sentenceType,
            string nameAttribute,
            string valueAttribute,
            XmlDocument doc
        )
        {
            XmlElement newXmlElement = doc.CreateElement(type.ToString());

            switch (type)
            {
                case ContextMenuSettingDefinition.Classification.separator:
                    break;
                case ContextMenuSettingDefinition.Classification.folder:
                    newXmlElement.SetAttribute(ContextMenuSettingDefinition.Name_, nameAttribute);
                    break;
                case ContextMenuSettingDefinition.Classification.sentence:
                    newXmlElement.SetAttribute(ContextMenuSettingDefinition.Type_, sentenceType.ToString());
                    switch (sentenceType)
                    {
                        case ContextMenuSettingDefinition.SentenceType.template:
						case ContextMenuSettingDefinition.SentenceType.complex:
							if (!string.IsNullOrEmpty(nameAttribute))
                            {
                                newXmlElement.SetAttribute(ContextMenuSettingDefinition.Name_, nameAttribute);
                            }
                            newXmlElement.SetAttribute(ContextMenuSettingDefinition.Value_, valueAttribute);
                            break;
                        case ContextMenuSettingDefinition.SentenceType.clipboardhistory:
                        case ContextMenuSettingDefinition.SentenceType.execute:
                            newXmlElement.SetAttribute(ContextMenuSettingDefinition.Name_, nameAttribute);
                            newXmlElement.SetAttribute(ContextMenuSettingDefinition.Value_, valueAttribute);
                            break;
                        case ContextMenuSettingDefinition.SentenceType.editfile:
                            newXmlElement.SetAttribute(ContextMenuSettingDefinition.Name_, global::ClipClop.Properties.Resources.MenuEdit);
                            newXmlElement.SetAttribute(ContextMenuSettingDefinition.Value_, valueAttribute);
                            break;
                    }

                    break;
            }


            return newXmlElement;
		}
	}


	public abstract class LaunchExec
	{
		#region EXE起動
		public class Pair
		{
			readonly string key_;
			readonly string value_;

			public Pair(string key, string value)
			{
				key_ = key;
				value_ = value;
			}

			public string Key
			{
				get
				{
					return this.key_;
				}
			}
			public string Value
			{
				get
				{
					return this.value_;
				}
			}
		}

		public static readonly Pair[] ExeNames = { 
													new Pair("EXPLORER","explorer.exe"),
													new Pair("NOTEPAD","notepad.exe"),
													new Pair("CONTROL","control.exe"),
		};

		public static string FindExecuteString(string value)
		{
			foreach (Pair p in ExeNames)
			{
				if (value.Equals(p.Key))
				{
					return value.Replace(p.Key, p.Value);
				}
			}

			return null;
		}


		public static string GetExecuteString(XmlNode node)
		{
			string value = XmlNodeHelper.GetDisplayValue(node);
			if (string.IsNullOrEmpty(value))
				return string.Empty;

			string exec = FindExecuteString(value);

			if (!string.IsNullOrEmpty(exec))
			{
				//はじめから組み込まれているEXEの場合
				StringBuilder sb = new StringBuilder(512);
				IntPtr ptr = new IntPtr();

				uint ret = WinApi.Kernel32.SearchPath(null,
					exec,
					 null,
					 sb.Capacity,
					 sb,
					 out ptr);
				if (ret == 0)
				{
					return exec;
				}

				return sb.ToString();
			}

			return value;
		}
		#endregion
	}
}
