﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.IO;
using System.Xml;
using CaLib.User;

namespace ClipClop.View
{
	public partial class TemplateItemForm : Form
	{
		public TemplateItemForm()
		{
			InitializeComponent();
            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryTemplateItemForm, this);
        }


		public TemplateItemForm(ContextMenuSettingDefinition.Mode mode, string dispalyName, string dispalyValue)
		{
			InitializeComponent();

            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryTemplateItemForm, this);

			this.comboBoxType.DataSource = ContextMenuSettingDefinition.ModeNamestrings;
			this.comboBoxType.ValueMember = "Value";
			this.comboBoxType.DisplayMember = "Key";

			UpdateControls(mode, dispalyName, dispalyValue);
		}


		void UpdateControls(ContextMenuSettingDefinition.Mode mode, string dispalyName, string dispalyValue)
		{
			switch (mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
				case ContextMenuSettingDefinition.Mode.execute:
					this.textBoxName.Text = dispalyName;
					this.textBoxValue.Text = dispalyValue;
					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					this.textBoxName.Text = string.Empty;
					this.textBoxValue.Text = string.Empty;
					break;
			}

			this.comboBoxType.SelectedIndex = (int)mode;
		}

		private void comboBoxType_SelectedValueChanged(object sender, EventArgs e)
		{
			ContextMenuSettingDefinition.Mode mode = (ContextMenuSettingDefinition.Mode)this.comboBoxType.SelectedIndex;
			switch (mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
				case ContextMenuSettingDefinition.Mode.execute:
					this.textBoxName.Enabled = true;
					this.textBoxValue.Enabled = true;
					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					this.textBoxName.Enabled = false;
					this.textBoxValue.Enabled = false;
					break;
			}
		}

		public string DispValue
		{
			get
			{
				return this.textBoxValue.Text;
			}
		}
		public string DispName
		{
			get
			{
				return this.textBoxName.Text;
			}
		}
		public ContextMenuSettingDefinition.Mode Mode
		{
			get
			{
				return (ContextMenuSettingDefinition.Mode)this.comboBoxType.SelectedIndex;
			}
		}

        bool bValidInput_ = false;

		private void buttonOK_Click(object sender, EventArgs e)
		{
            bValidInput_ = false;
       
			ContextMenuSettingDefinition.Mode mode = (ContextMenuSettingDefinition.Mode)this.comboBoxType.SelectedIndex;
			switch (mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}
					//名前は空でもいい
					break;
				case ContextMenuSettingDefinition.Mode.execute:
					if (string.IsNullOrEmpty(this.textBoxName.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG002);
						return;
					}
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}

					string exec = ContextMenuSettingHelper.FindExecuteString(this.textBoxValue.Text);
					if (!string.IsNullOrEmpty(exec))
					{
						//exeファイルのパスが指定された場合
						//ファイル名に使用できない文字を取得
						char[] invalidChars = Path.GetInvalidFileNameChars();

						if (exec.IndexOfAny(invalidChars) > -1)
						{
							Util.ShowWarn(global::ClipClop.Properties.Resources.MSG003);
							return;
						}
					}

					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					break;
			}

            bValidInput_ = true;
			//this.Close();
		}

        private void TemplateItemForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                e.Cancel = false;
                if (bValidInput_ == false)
                {
                    e.Cancel = true;
                    return;
                }
            }

            Properties.Settings.Default.WindowGeometryTemplateItemForm = FormUtil.GeometryToString(this);
        }

        private void textBoxValue_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.Copy;
        }

        private void textBoxValue_DragDrop(object sender, DragEventArgs e)
        {
            string[] dropFiles = (string[])e.Data.GetData(DataFormats.FileDrop);
            if( dropFiles.Length > 0 )
                textBoxValue.Text = dropFiles[0];
        }
	}
}
