﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CaLib.User.PropertyGridUtil
{
	/// <summary>
	/// プロパティの説明（＝情報）を提供するクラス。DisplayNameをカスタマイズする。
	/// </summary>
	public class PropertyDisplayPropertyDescriptor : PropertyDescriptor
	{
		private PropertyDescriptor oneProperty;

		public PropertyDisplayPropertyDescriptor(PropertyDescriptor desc)
			: base(desc)
		{
			oneProperty = desc;
		}

		public override bool CanResetValue(object component)
		{
			return oneProperty.CanResetValue(component);
		}

		public override Type ComponentType
		{
			get
			{
				return oneProperty.ComponentType;
			}
		}

		public override object GetValue(object component)
		{
			return oneProperty.GetValue(component);
		}

		public override string Description
		{
			get
			{
				return oneProperty.Description;
			}
		}

		public override string Category
		{
			get
			{
				return oneProperty.Category;
			}
		}

		public override bool IsReadOnly
		{
			get
			{
				return oneProperty.IsReadOnly;
			}
		}

		public override void ResetValue(object component)
		{
			oneProperty.ResetValue(component);
		}

		public override bool ShouldSerializeValue(object component)
		{
			return oneProperty.ShouldSerializeValue(component);
		}

		public override void SetValue(object component, object value)
		{
			oneProperty.SetValue(component, value);
		}

		public override Type PropertyType
		{
			get
			{
				return oneProperty.PropertyType;
			}
		}

		public override string DisplayName
		{
			get
			{
				PropertyDisplayNameAttribute attrib =
					(PropertyDisplayNameAttribute)oneProperty.Attributes[typeof(PropertyDisplayNameAttribute)];
				if (attrib != null)
				{
					return attrib.PropertyDisplayName;
				}

				return oneProperty.DisplayName;
			}
		}

	}

}
