﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CaLib.User
{
	/// <summary>
	/// クリップボードにコピーされた文字列を格納するクラス
	/// </summary>
	public class ClipboardEventArgs : EventArgs
	{
		private string text;

		public string Text
		{
			get { return this.text; }
		}

		public ClipboardEventArgs(string str)
		{
			this.text = str;
		}
	}

	public delegate void cbEventHandler(object sender, ClipboardEventArgs ev);

	/// <summary>
	/// クリップボード変化時に生成されるクラス
	/// </summary>
	public class ClipboardEventNotifyArgs : EventArgs
	{
		public enum DataKind
		{
			audio, data, fileDropList, image, text
		}

		public readonly DataKind kind_ ;

		public ClipboardEventNotifyArgs(DataKind kind)
		{
			kind_ = kind;
		}
	}

	public delegate void cbEventNotifyHandler(object sender, ClipboardEventNotifyArgs ev);
}
