﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using ClipClop.User;

namespace ClipClop.View
{
	public class TemplateSettingTreeNode : TreeNode
	{
		XmlNode xmlNode_;

		public TemplateSettingTreeNode()
		{
		}

		public TemplateSettingTreeNode(string text, XmlNode xmlNode)
			: base(text)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, TreeNode[] children, XmlNode xmlNode)
			: base(text, children)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, int imageIndex, int selectedImageIndex, XmlNode xmlNode)
			: base(text, imageIndex, selectedImageIndex)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, int imageIndex, int selectedImageIndex, TreeNode[] children, XmlNode xmlNode)
			: base(text, imageIndex, selectedImageIndex, children)
		{
			this.xmlNode_ = xmlNode;
		}

		public ContextMenuSettingDefinition.SettingType SettingType
		{
			get
			{
				return ContextMenuSettingHelper.GetSettingType(this.xmlNode_);
			}
		}

		public string NameAttribute
		{
			get 
			{
				string name = ContextMenuSettingHelper.GetAttributeValue(this.xmlNode_, ContextMenuSettingDefinition.Name_);
				return name;
			}
		}

		public string DispalyName
		{
			get
			{
				string name =  ContextMenuSettingHelper.GetDisplayString(this.xmlNode_);
				return name;
			}
		}

		public string DispalyValue
		{
			get
			{
				return ContextMenuSettingHelper.GetValue(this.xmlNode_);
			}
		}

		public ContextMenuSettingDefinition.Mode Mode
		{
			get{
				return ContextMenuSettingHelper.GetMode(this.xmlNode_);
			}
		}

		public bool EditAttribute(ContextMenuSettingDefinition.Mode mode, string name, string value, XmlDocument doc)
		{
			if (!ContextMenuSettingHelper.SetTypeAttribute(this.xmlNode_, mode))
				return false;

			if (string.IsNullOrEmpty(name))
			{
				if (!ContextMenuSettingHelper.RemoveNameAttribute(this.xmlNode_))
					return false;
			}
			else
			{
				if (!ContextMenuSettingHelper.SetNameAttribute(this.xmlNode_, name, doc))
					return false;
			}

			if (!ContextMenuSettingHelper.SetValueAttribute(this.xmlNode_, value, doc))
				return false;
			return true;
		}

		public bool EditNameAttribute(string name)
		{
			if (!ContextMenuSettingHelper.SetNameAttribute(this.xmlNode_, name, null))
				return false;
			return true;
		}


		public bool EditDispalyName(string str, XmlDocument doc)
		{
			string name = ContextMenuSettingHelper.GetAttributeValue(this.xmlNode_, ContextMenuSettingDefinition.Name_);
			if (string.IsNullOrEmpty(name))
			{
				//name属性がないということはvalue属性のみ設定されている
				return ContextMenuSettingHelper.SetValueAttribute(this.xmlNode_, str, doc);
			}

			//
			return ContextMenuSettingHelper.SetNameAttribute(this.xmlNode_, str, doc);
		}

		public bool IsRoot()
		{
			return ContextMenuSettingHelper.IsRoot(this.xmlNode_);
		}

		/// <summary>
		/// 要素を追加できるかどうか
		/// </summary>
		/// <returns></returns>
		public bool IsAddable()
		{
			if (this.IsRoot())
				return true;
			if (this.IsFolder())
				return true;
			return false;
		}

		public bool IsEditable()
		{
			if (this.IsRoot())
				return false;
			if (this.SettingType == ContextMenuSettingDefinition.SettingType.separator)
				return false;
			return true;
		}

		public bool IsFirstElement()
		{
			TreeNodeCollection col = this.Parent.Nodes;
			if (col.Count < 0)
				return false;

			if (col[0] == this)
				return true;
			return false;
		}

		public bool IsLastElement()
		{
			TreeNodeCollection col = this.Parent.Nodes;
			if (col.Count < 0)
				return false;

			if (col[col.Count-1] == this)
				return true;
			return false;
		}

		public bool IsFolder()
		{
			ContextMenuSettingDefinition.SettingType type = ContextMenuSettingHelper.GetSettingType(this.xmlNode_);

			return type == ContextMenuSettingDefinition.SettingType.folder ? true : false;
		}



		public void AppendChild(XmlNode xmlNode, int imageListItem)
		{
			this.xmlNode_.AppendChild(xmlNode);

			TemplateSettingTreeNode tn = new TemplateSettingTreeNode(
												ContextMenuSettingHelper.GetDisplayString(xmlNode)
												, imageListItem
												, imageListItem
												, xmlNode
											);

			this.Nodes.Add(tn);
		}


		public void DeleteNode()
		{
			this.xmlNode_.ParentNode.RemoveChild(this.xmlNode_);

			this.Remove();
		}

		public XmlNode CopyXmlNode()
		{
			return (XmlNode)this.xmlNode_.Clone();
		}

		public int GetIndex()
		{
			XmlNodeList nodes = this.xmlNode_.ParentNode.ChildNodes;

			for (int i = 0; i < nodes.Count; i++)
			{
				if (nodes[i] == this.xmlNode_)
					return i;
			}
			return -1;
		}

		public void MoveAbove()
		{
			XmlNode parent = this.xmlNode_.ParentNode;

			int targetIndex = this.GetIndex();

			XmlNode my = parent.ChildNodes[targetIndex];
			XmlNode prev = parent.ChildNodes[targetIndex-1];

			parent.RemoveChild(prev);
			parent.InsertAfter(prev, my);
		}

		public void MoveBelow()
		{
			XmlNode parent = this.xmlNode_.ParentNode;

			int targetIndex = this.GetIndex();

			XmlNode my = parent.ChildNodes[targetIndex];
			XmlNode next = parent.ChildNodes[targetIndex+1];

			parent.RemoveChild(next);
			parent.InsertBefore(next, my);
		}

		public void Update()
		{
			this.Text = this.DispalyName;

			TemplateSettingTreeView.ImageListItem idx = TemplateSettingTreeView.GetImageItem(this.xmlNode_);

			base.ImageIndex = (int)idx;
			base.SelectedImageIndex = (int)idx;
		}

		
	}
}
