﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.IO.Compression;
using System.Diagnostics;

namespace ClipClop.User
{
	public abstract class Util
	{
		public static void ShowError(string msg)
		{
			Trace.WriteLine("[Error] " + msg);

			MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
		}

		public static void ShowWarn(string msg)
		{
			Trace.WriteLine("[Warn ] "+msg);

			MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		}

		public static bool Confirm(string msg)
		{
			DialogResult ret = MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
			if (ret == DialogResult.Yes)
				return true;
			return false;
		}

        public static string MakeFileName(string input)
        {
            char[] invalidChars = Path.GetInvalidFileNameChars();

            foreach (char c in invalidChars)
            {
                while (true)
                {
                    int n = input.IndexOf(c);
                    if (n < 0)
                        break;
                    input = input.Remove(n, 1);
                }
            }
            return input.Length < 255 ? input : input.Substring(0, 255);
        }

		public static void Compress(string src, string dest)
		{
			//圧縮モードのGZipStreamを作成する
			using (GZipStream gzipStrm = new GZipStream(new FileStream(dest, System.IO.FileMode.Create), CompressionMode.Compress))
			{

				//圧縮するファイルを開いて少しずつbufferに読み込む
				using (FileStream inFileStrm = new FileStream(src, FileMode.Open, FileAccess.Read))
				{

					byte[] buffer = new byte[1024];
					while (true)
					{
						//圧縮するファイルからデータを読み込む
						int readSize = inFileStrm.Read(buffer, 0, buffer.Length);

						//最後まで読み込んだ時は、ループを抜ける
						if (readSize == 0)
							break;
						//データを圧縮して書き込む
						gzipStrm.Write(buffer, 0, readSize);
					}

					//閉じる
					inFileStrm.Close();
				}

				gzipStrm.Close();
			}
		}

	}
}
