﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using ClipClop.User;
using CaLib.User;

namespace ClipClop.View
{
	public partial class SettingForm : Form
	{
		public ClipClop.Model.AplSetting Setting { get; private set; }

		string passwrodString_;
		public string Password { 
			get 
			{ 
				return this.passwrodString_; 
			}
		}

		//デザイン用
		public SettingForm()
		{
			InitializeComponent();
		}
	
		public SettingForm(ClipClop.Model.AplSetting setting,string password)
		{
			InitializeComponent();

            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometrySettingForm, this);

			this.Setting = setting;

			this.propertyGrid.SelectedObject = this.Setting;

			this.passwrodString_ = password;
		}

        private void SettingForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.WindowGeometrySettingForm = FormUtil.GeometryToString(this);
        }


		/// <summary>
		/// PropertyGridコントロール上でプロパティ値が変更されたときに発生する
		/// </summary>
		/// <param name="s"></param>
		/// <param name="e"></param>
		/// <see cref="http://www.atmarkit.co.jp/fdotnet/dotnettips/288pgridevent/pgridevent.html"/>
		private void propertyGrid_PropertyValueChanged(object s, PropertyValueChangedEventArgs e)
		{
			//TODO TypeConverterを作れば、改善できたような記憶がある。

			// プロパティの名前を取得する
			string propertyName = e.ChangedItem.PropertyDescriptor.Name;
			if (!propertyName.Equals("templateFilePath_"))
				return;

			XmlContextMenuReader reader = new XmlContextMenuReader();
			reader.Read((string)e.ChangedItem.Value);

			if (reader.GetDocument().IsEncrypted())
			{
				//暗号化されている場合
				if (!PasswordForm.ShowInputPassword(ref this.passwrodString_))
				{
					//TODO e.OldValueの値で元に戻す
					throw new FundamentalException(global::ClipClop.Properties.Resources.EF010);
				}
			}						
		}
	}
}
