﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.Diagnostics;

namespace ClipClop.View
{
	public partial class ContextMenuParentForm : Form
	{
		public ContextMenuParentForm()
		{
			InitializeComponent();

			//枠を消す
			this.FormBorderStyle = FormBorderStyle.None;
		}

		private void ContextMenuParentForm_Shown(object sender, EventArgs e)
		{
			//インスタンス生成後一回だけ
			//this.ContextMenuStrip.Show(this.Location);
		}

		private void ContextMenuParentForm_Activated(object sender, EventArgs e)
		{
			//表示がアクティブになる度に呼ばれる
			this.ContextMenuStrip.Show(this.Location);
		}


		/// <summary>
		/// ContextMenuが閉じたら呼ばれるようにしているイベント
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void OnContextMenuClosed(object sender, ToolStripDropDownClosedEventArgs e)
		{
			this.Close();
		}

		private void ContextMenuParentForm_Deactivate(object sender, EventArgs e)
		{
			//Debug.WriteLine(this.ContextMenuStrip.Visible) ;

			if (this.ContextMenuStrip.Visible == false)
			{
				//ContextMenuのアイテムが選択された
			}
			else
			{
				//フォーカスが外れた
				this.Close();
			}
		}

		
	}
}
