﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.Xml;
using System.Diagnostics;
using System.IO;
using CaLib.User;

namespace ClipClop.View
{
	//TODO ○定型文アイコン指定を可能にする

	/// <summary>
	/// 定型文定義ダイアログ。
	/// </summary>
    public partial class TemplateSetting : Form
    {
		XmlDocument doc_;

		readonly string templateFilePath_;

		public XmlDocument Document
		{
			get
			{
				return this.doc_;
			}
		}

        public TemplateSetting()
        {
            InitializeComponent();

			//アイテムをユーザーが編集できるようにする
			this.treeView.LabelEdit = true;
        }

		public TemplateSetting(ContextMenuSettingManager mngr, string templateFilePath)
		{
			InitializeComponent();

			doc_ = mngr.Document;
			templateFilePath_ = templateFilePath;

			//アイテムをユーザーが編集できるようにする
			this.treeView.LabelEdit = true;
		}

		private void TemplateSetting_Load(object sender, EventArgs e)
		{
			if (doc_ == null)
				return;
			try
			{
				this.Cursor = Cursors.WaitCursor;
				this.treeView.Setup(this.doc_);
			}
			catch (Exception exp)
			{
				Util.ShowError(global::ClipClop.Properties.Resources.EF005 + Environment.NewLine + exp.Message);
			}
			finally
			{
				this.Cursor = Cursors.Default;
			}
		}

		/// <summary>
		/// Formの表示を初期化する
		/// </summary>
		void Initialize()
		{
			doc_ = null;

			this.treeView.Nodes.Clear();
		}

		/// <summary>
		/// QT Clipの設定ファイルをインポートする
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void importToolStripMenuItem_Click_1(object sender, EventArgs e)
		{
			string filePath;

			using (OpenFileDialog fd = new OpenFileDialog())
			{
				fd.FileName = "QTCLIP.TXT";
				fd.Filter = "TEXTファイル(*.TXT)|*.TXT|すべてのファイル(*.*)|*.*";


				DialogResult result = fd.ShowDialog();
				if (result != DialogResult.OK)
					return;
				filePath = fd.FileName;
			}

			try
			{
				this.Cursor = Cursors.WaitCursor;

				QtClipContextMenuReader reader = new QtClipContextMenuReader();

				reader.Read(filePath);

				// Formの表示を初期化する
				Initialize();

				this.doc_ = reader.GetDocument();

				this.treeView.Setup(this.doc_);

			}
			catch (Exception exp)
			{
				Util.ShowError(global::ClipClop.Properties.Resources.EF005 + Environment.NewLine + exp.Message);
			}
			finally
			{
				this.Cursor = Cursors.Default;
			}

		}

		private void treeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			TemplateSettingTreeNode node = e.Node as TemplateSettingTreeNode;

			if (node == null)
			{
				this.textBox.Text = string.Empty;
				UpdateContextMenu(false);
			}
			else
			{
				this.textBox.Text = node.DispalyValue;
				UpdateContextMenu(true);
			}
		}

		private void treeView_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
		{
			TemplateSettingTreeNode tsnode = e.Node as TemplateSettingTreeNode;
			if (tsnode == null)
			{
				return;
			}

			Debug.WriteLine(tsnode.ToString());

			TemplateSettingTreeNode node = (TemplateSettingTreeNode)e.Node;

			if (node.SettingType != ContextMenuSettingDefinition.SettingType.sentence )
			{
				//編集できるのは、定型文のみ。
				return;
			}

			// ダイアログを表示する。
			using (TemplateItemForm form = new TemplateItemForm(this.doc_, node))
			{
				DialogResult result = form.ShowDialog();
				if (result != DialogResult.OK)
					return;

				//...OKであれば、コンストラクタで渡したインスタンスが書き換えられる。

			}
		}


		/// <summary>
		/// 定型文定義ファイルを開く
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void openOToolStripMenuItem_Click(object sender, EventArgs e)
		{
			string filePath;

			using (OpenFileDialog fd = new OpenFileDialog())
			{
				fd.FileName = Path.GetFileName(this.templateFilePath_);
				fd.Filter = "XMLファイル(*.XML)|*.XML|すべてのファイル(*.*)|*.*";


				DialogResult result = fd.ShowDialog();
				if (result != DialogResult.OK)
					return;
				filePath = fd.FileName;
			}

			try
			{
				this.Cursor = Cursors.WaitCursor;

				XmlContextMenuReader reader = new XmlContextMenuReader();

				reader.Read(filePath);

				// Formの表示を初期化する
				Initialize();

				this.doc_ = reader.GetDocument();

				this.treeView.Setup(this.doc_);

			}
			catch (Exception exp)
			{
				Util.ShowError(global::ClipClop.Properties.Resources.EF005 + Environment.NewLine + exp.Message);
			}
			finally
			{
				this.Cursor = Cursors.Default;
			}
		}

		#region TreeViewアイテム名の変更

		/// <summary>
		/// キーが離れた時
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void treeView_KeyUp(object sender, KeyEventArgs e)
		{
			//F2キーが離されたときは、フォーカスのあるアイテムの編集を開始
			if (e.KeyCode == Keys.F2 && this.treeView.SelectedNode != null)
			{
				this.treeView.SelectedNode.BeginEdit();
			}
		}

		/// <summary>
		/// アイテムのラベルの編集が開始された時
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void treeView_BeforeLabelEdit(object sender, NodeLabelEditEventArgs e)
		{
			//ルートアイテムは編集できないようにする
			TemplateSettingTreeNode node = e.Node as TemplateSettingTreeNode;

			if (node == null || node.IsRoot())
				e.CancelEdit = true;
			else
				e.CancelEdit = false;
		}

		/// <summary>
		/// アイテムのラベルの編集された時
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void treeView_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
		{
			if (e.Label == null)
				return;

			TemplateSettingTreeNode node = e.Node as TemplateSettingTreeNode;
			Debug.Assert(node != null);
			Debug.Assert(!node.IsRoot());

			bool ret = node.EditDispalyName(e.Label, this.doc_);
			if (ret == false)
			{
				throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);
			}
			else
			{
				this.textBox.Text = node.DispalyValue;
			}
		}

		#endregion

		#region コンテキストメニュー

		private void UpdateContextMenu(bool bItemSelected)
		{
			//TODO 今後対応する
			/*
			追加AToolStripMenuItem.Enabled = true;

			削除DToolStripMenuItem.Enabled = bItemSelected;
			編集EToolStripMenuItem.Enabled = bItemSelected;
			コピーCToolStripMenuItem.Enabled = bItemSelected;
			カットCToolStripMenuItem.Enabled = bItemSelected;
			ペーストPToolStripMenuItem.Enabled = bItemSelected;
			上に移動UToolStripMenuItem.Enabled = bItemSelected;
			下に移動ToolStripMenuItem.Enabled = bItemSelected;
			*/
			追加AToolStripMenuItem.Enabled = false;

			削除DToolStripMenuItem.Enabled = false;
			編集EToolStripMenuItem.Enabled = false;
			コピーCToolStripMenuItem.Enabled = false;
			カットCToolStripMenuItem.Enabled = false;
			ペーストPToolStripMenuItem.Enabled = false;
			上に移動UToolStripMenuItem.Enabled = false;
			下に移動ToolStripMenuItem.Enabled = false;


			すべて展開ToolStripMenuItem.Enabled = true;
			全てたたむToolStripMenuItem.Enabled = true;
		}

		private void すべて展開ToolStripMenuItem_Click(object sender, EventArgs e)
		{
			this.treeView.ExpandAll();
		}

		private void 全てたたむToolStripMenuItem_Click(object sender, EventArgs e)
		{
			this.treeView.CollapseAll();
		}

		private void フォルダToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void セパレーターToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void 定型文ToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void コピーCToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void カットCToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void ペーストPToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void 上に移動UToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void 下に移動ToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}
		#endregion

	}
}
