﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;

namespace ClipClop.View
{
	public partial class AboutForm : Form
	{
		public AboutForm()
		{
			InitializeComponent();


			//http://www.atmarkit.co.jp/fdotnet/dotnettips/282verinfodlg/verinfodlg.html

			Assembly mainAssembly = Assembly.GetEntryAssembly();

			// コピーライト情報を取得
			string appCopyright = "-";
			object[] CopyrightArray =
			  mainAssembly.GetCustomAttributes(
				typeof(AssemblyCopyrightAttribute), false);
			if ((CopyrightArray != null) && (CopyrightArray.Length > 0))
			{
				appCopyright =
				  ((AssemblyCopyrightAttribute)CopyrightArray[0]).Copyright;
			}

			// 詳細情報を取得
			string appDescription = "-";
			object[] DescriptionArray =
			  mainAssembly.GetCustomAttributes(
				typeof(AssemblyDescriptionAttribute), false);
			if ((DescriptionArray != null) && (DescriptionArray.Length > 0))
			{
				appDescription =
				  ((AssemblyDescriptionAttribute)DescriptionArray[0]).Description;
			}


			StringBuilder sb = new StringBuilder();

			sb.AppendLine(string.Format("Product Version {0}", Application.ProductVersion));
			sb.AppendLine(string.Format("Product Name    {0}", Application.ProductName));
			//sb.AppendLine(string.Format("Company Name    {0}", Application.CompanyName));
			sb.AppendLine(appCopyright);
			sb.AppendLine(appDescription);
			sb.AppendLine("\n--------------");
			sb.AppendLine(global::ClipClop.Properties.Resources.Credit);

			this.textBox.AppendText(sb.ToString());
		}

		private void buttonOK_Click(object sender, EventArgs e)
		{
			this.Close();
		}
	}
}
