﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Xml;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;
using ClipClop.Model;

namespace ClipClop.User
{
	//TODO ○シュートカットキーに対応する

	/// <summary>
	/// 定義ファイルから読み込んだアイテムを表示するコンテキストメニュークラス
	/// </summary>
	public class DynamicContextMenuStrip : System.Windows.Forms.ContextMenuStrip
	{
		ContextMenuSettingManager settingManager_ = new ContextMenuSettingManager();

		public ContextMenuSettingManager Manager
		{
			get
			{
				return this.settingManager_;
			}
		}

		AplSetting aplSetting_;

		public AplSetting AplSetting
		{
			set
			{
				this.aplSetting_ = value;
			}
		}

		public DynamicContextMenuStrip() : base()
		{
		}

		public DynamicContextMenuStrip(IContainer container)
			: base(container)
		{
		}

		//protected override void WndProc(ref Message m)
		//{
		//    base.WndProc(ref m);
		//}

		/// <summary>
		/// メニュー表示時に親ウィンドウが非表示だったかどうか
		/// </summary>
		public bool ParentVisible { get; set; }

		public bool Read(string filePath, ContextMenuSettingManager.FileType type)
		{
			return settingManager_.Read(filePath, type);
		}

		public void ConstructMenu()
		{
			this.Items.Clear();
			//this.menuEventHanders_.Clear();
			
			if (null == settingManager_.RootNode)
				return;

			RecursiveConstructMenu(settingManager_.RootNode, this.Items);
		}

		void RecursiveConstructMenu(XmlNode parentnode, ToolStripItemCollection items)
		{
			foreach (XmlNode childXmlNode in parentnode.ChildNodes)
			{
				if (ContextMenuSettingHelper.GetSettingType(childXmlNode) == ContextMenuSettingDefinition.SettingType.separator)
				{
					items.Add( new ToolStripSeparator() );
					continue;
				}

				ToolStripMenuItemEx menu = new ToolStripMenuItemEx(childXmlNode,this.aplSetting_);

				//TODO クリップボード履歴は未対応
				if (ContextMenuSettingHelper.GetSettingType(childXmlNode) == ContextMenuSettingDefinition.SettingType.sentence 
					&& ContextMenuSettingHelper.GetMode(childXmlNode) == ContextMenuSettingDefinition.Mode.clipboardhistory)
				{
					menu.Enabled = false;
				}

				items.Add(menu);

				// 再帰呼び出し
				RecursiveConstructMenu(childXmlNode, menu.DropDownItems);
			}
		}

		class ToolStripMenuItemEx : ToolStripMenuItem
		{
			readonly XmlNode node_;

			readonly AplSetting aplSetting_;

			public ToolStripMenuItemEx(XmlNode node, AplSetting aplSetting)
				: base(ContextMenuSettingHelper.GetDisplayString(node))
			{
				this.node_ = node;
				this.aplSetting_ = aplSetting;
				base.Click += this.OnMenuEvent;
			}

			public ToolStripMenuItem CreatetMenu()
			{
				ToolStripMenuItem menu = new ToolStripMenuItem();
				return menu;
			}


			public void StartProcess(string exeString)
			{

				System.Diagnostics.Process process = null;
				try
				{
					process = System.Diagnostics.Process.Start(exeString);
				}
				catch (Exception exp)
				{
					Util.ShowError(global::ClipClop.Properties.Resources.EF003 + Environment.NewLine + exp.Message + Environment.NewLine + exeString);
					return;
				}

				if (process == null)
				{
					Util.ShowError(global::ClipClop.Properties.Resources.EF003);
				}
			}

			/// <summary>
			/// メニューがクリックされた
			/// </summary>
			/// <param name="sender"></param>
			/// <param name="e"></param>
			public void OnMenuEvent(object sender, EventArgs e)
			{
				if (ContextMenuSettingDefinition.Sentence_ != node_.Name)
					return;

				//TODO ○クリップボードにコピーするクラスが必要かも

				ContextMenuSettingDefinition.Mode mode = ContextMenuSettingHelper.GetMode(this.node_);

				Debug.WriteLine(string.Format("{0},{1},{2}", ContextMenuSettingHelper.GetDisplayString(node_), ContextMenuSettingHelper.GetValue(node_), mode));

				switch (mode)
				{
					case ContextMenuSettingDefinition.Mode.execute:
						//Exe実行の場合

						string exeString = ContextMenuSettingHelper.GetExecuteString(node_);

						StartProcess(exeString);

						return;

					case ContextMenuSettingDefinition.Mode.editfile:
						StartProcess(this.aplSetting_.templateFilePath_);

						return;
				}

				

				string value = ContextMenuSettingHelper.GetValueReplaced(node_, DateTime.Now);

				// リストに二つ入るけれど、リストで先頭と同じなら挿入しないようにした。
				Clipboard.SetDataObject(value, true);
			}
		}

        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // DynamicContextMenuStrip
            // 
            this.ResumeLayout(false);

        }
	}
}
