﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace CaLib.User
{
	public class ImageListBox : LimitedListBox
	{
		public ImageListBox()
		{
			this.ItemHeight = 128;
			this.ScrollAlwaysVisible = true;
			this.DrawMode = DrawMode.OwnerDrawFixed;
		}

		/// <summary>
		/// RemoveOldでアイテムが削除されるときに呼ばれます。
		/// </summary>
		/// <param name="s"></param>
		public override void OnRemoveItem(object s, int index)
		{
			Image img = s as Image;

			if (img == null)
				return;

			img.Dispose();
		}
	}
}
