﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Threading;
using ClipClop.Model;
using System.Diagnostics;
using System.IO;

namespace ClipClop
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		/// <see cref="http://www.atmarkit.co.jp/fdotnet/dotnettips/848cbviewer/cbviewer.html"/>
		/// <see cref="http://www.codeproject.com/KB/clipboard/ClipSpyPlus.aspx"/>
		[STAThread]
		static void Main()
		{
			// Mutex の新しいインスタンスを生成する (Mutex の名前にアセンブリ名を付ける)
			Mutex hMutex = new Mutex(false, Application.ProductName);

			// Mutex のシグナルを受信できるかどうか判断する
			bool bNoExist = hMutex.WaitOne(0, false);
			if (bNoExist)
			{
				Application.EnableVisualStyles();
				Application.SetCompatibleTextRenderingDefault(false);

				StreamWriter debugLog = null;		

				string[] args = Environment.GetCommandLineArgs();
				foreach (string s in args)
				{
					if (s.Equals("/dbg"))
					{
						Directory.CreateDirectory(AplSetting.APP_DATA_FOLDER_);

						string filepath = Path.Combine(AplSetting.APP_DATA_FOLDER_, "debug.log");
						debugLog = new StreamWriter(filepath);
						debugLog.AutoFlush = true;
						Trace.Listeners.Add(new TextWriterTraceListener(TextWriter.Synchronized(debugLog), "LogFile"));
						Trace.WriteLine(string.Format("{0} {1} ver={2} start",DateTime.Now.ToString(), Application.ProductName, Application.ProductVersion));
					}
				}

				try
				{
					Application.Run(new ClipClop.View.MainForm());
				}
				catch (Exception e)
				{
					if (debugLog != null)
					{
						debugLog.WriteLine(e.Message);
						debugLog.Close();
					}
					throw e;
				}

				Properties.Settings.Default.Save();
			}
			/*
			else
			{
				MessageBox.Show("二重起動", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			*/

			// GC.KeepAlive メソッドが呼び出されるまで、ガベージ コレクション対象から除外される
			GC.KeepAlive(hMutex);

			// Mutex を閉じる
			hMutex.Close();
		}
	}
}
