﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ClipClop.View
{
	public partial class EditHistoryForm : Form
	{
		public string HistoryString
		{
			get
			{
				return this.textBox.Text;
			}

			set
			{
				this.textBox.Text = value;
			}
		}

		public EditHistoryForm()
		{
			InitializeComponent();

			FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryEditHistoryForm, this);
		}

		private void EditHistoryForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			Properties.Settings.Default.WindowGeometryEditHistoryForm = FormUtil.GeometryToString(this);
		}

		public void Setup(double opacity, Font f)
		{
			this.Opacity = opacity;
			this.textBox.Font = f;
		}
	}
}
