﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Threading;

namespace ClipClop
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		/// <see cref="http://www.atmarkit.co.jp/fdotnet/dotnettips/848cbviewer/cbviewer.html"/>
		/// <see cref="http://www.codeproject.com/KB/clipboard/ClipSpyPlus.aspx"/>
		[STAThread]
		static void Main()
		{
			// Mutex の新しいインスタンスを生成する (Mutex の名前にアセンブリ名を付ける)
			Mutex hMutex = new Mutex(false, Application.ProductName);

			// Mutex のシグナルを受信できるかどうか判断する
			bool bNoExist = hMutex.WaitOne(0, false);
			if (bNoExist)
			{
				Application.EnableVisualStyles();
				Application.SetCompatibleTextRenderingDefault(false);
				Application.Run(new ClipClop.View.MainForm());
			}
			/*
			else
			{
				MessageBox.Show("二重起動", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			*/

			// GC.KeepAlive メソッドが呼び出されるまで、ガベージ コレクション対象から除外される
			GC.KeepAlive(hMutex);

			// Mutex を閉じる
			hMutex.Close();
		}
	}
}
