﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using ClipClop.User;

namespace ClipClop.View
{
	public class TemplateSettingTreeNode : TreeNode
	{
		XmlNode xmlNode_;

		public TemplateSettingTreeNode()
		{
		}

		public TemplateSettingTreeNode(string text, XmlNode xmlNode)
			: base(text)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, TreeNode[] children, XmlNode xmlNode)
			: base(text, children)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, int imageIndex, int selectedImageIndex, XmlNode xmlNode)
			: base(text, imageIndex, selectedImageIndex)
		{
			this.xmlNode_ = xmlNode;
		}

		public TemplateSettingTreeNode(string text, int imageIndex, int selectedImageIndex, TreeNode[] children, XmlNode xmlNode)
			: base(text, imageIndex, selectedImageIndex, children)
		{
			this.xmlNode_ = xmlNode;
		}

		public ContextMenuSettingDefinition.SettingType SettingType
		{
			get
			{
				return ContextMenuSettingHelper.GetSettingType(this.xmlNode_);
			}
		}

		public string DispalyName
		{
			get
			{
				string name =  ContextMenuSettingHelper.GetDisplayString(this.xmlNode_);
				return name;
			}
		}

		public string DispalyValue
		{
			get
			{
				return ContextMenuSettingHelper.GetValue(this.xmlNode_);
			}
		}

		public ContextMenuSettingDefinition.Mode Mode
		{
			get{
				return ContextMenuSettingHelper.GetMode(this.xmlNode_);
			}
		}

		public bool EditAttribute(ContextMenuSettingDefinition.Mode mode, string name, string value, XmlDocument doc)
		{
			if (!ContextMenuSettingHelper.SetTypeAttribute(this.xmlNode_, mode))
				return false;
			if (!ContextMenuSettingHelper.SetNameAttribute(this.xmlNode_, name, doc))
				return false;
			if (!ContextMenuSettingHelper.SetValueAttribute(this.xmlNode_, value, doc))
				return false;
			return true;
		}

		public bool EditDispalyName(string str, XmlDocument doc)
		{
			string name = ContextMenuSettingHelper.GetAttributeValue(this.xmlNode_, ContextMenuSettingDefinition.Name_);
			if (string.IsNullOrEmpty(name))
			{
				//name属性がないということはvalue属性のみ設定されている
				return ContextMenuSettingHelper.SetValueAttribute(this.xmlNode_, str, doc);
			}

			//
			return ContextMenuSettingHelper.SetNameAttribute(this.xmlNode_, str, doc);
		}

		public bool IsRoot()
		{
			return ContextMenuSettingHelper.IsRoot(this.xmlNode_);
		}

	}
}
