﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections.Specialized;
using System.Drawing;

namespace CaLib.User
{
	///// <summary>
	///// クリップボードにコピーされた文字列を格納するクラス
	///// </summary>
	//public class ClipboardEventArgs : EventArgs
	//{
	//    private string text;

	//    public string Text
	//    {
	//        get { return this.text; }
	//    }

	//    public ClipboardEventArgs(string str)
	//    {
	//        this.text = str;
	//    }
	//}

	//public delegate void cbEventHandler(object sender, ClipboardEventArgs ev);

	/// <summary>
	/// クリップボード変化時に生成されるクラス
	/// </summary>
	public class ClipboardEventNotifyArgs : EventArgs
	{
		public readonly MajorDivision division_;

		public readonly Stream audioStream_;
		public readonly IDataObject dataObject_;
		public readonly StringCollection fileDropList_;
		public readonly Image image_;
		public readonly string text_;

		public enum Classifications
		{
			Bitmap,
			CommaSeparatedValue,
			Dib,
			Dif,
			EnhancedMetafile,
			FileDrop,
			Html,
			Locale,
			MetafilePict,
			OemText,
			Palette,
			PenData,
			Riff,
			Rtf,
			Serializable,
			StringFormat,
			SymbolicLink,
			Text,
			Tiff,
			UnicodeText,
			WaveAudio,

			Unknown,
		}

		public enum MajorDivision
		{
			audio, data, fileDropList, image, text
		}

		public ClipboardEventNotifyArgs(MajorDivision division, Stream stream, IDataObject data, StringCollection list, Image img, string text)
		{
			this.division_ = division;

			this.audioStream_ = stream;
			this.dataObject_ = data;

			this.fileDropList_ = list;
			this.image_ = img;
			this.text_ = text;
		}
	}

	public delegate void cbEventNotifyHandler(object sender, ClipboardEventNotifyArgs ev);
}
