/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifdef _OPENMP
 # include <omp.h>
#endif
#include "ReducedLatticeToCheckEquiv.hh"
#include "../utility_lattice_reduction/put_Minkowski_reduced_lattice.hh"
#include "../utility_func/chToDouble.hh"
#include "../utility_data_structure/VCData.hh"
#include "../point_group/coset_representative_data.hh"


ReducedLatticeToCheckEquiv::ReducedLatticeToCheckEquiv(const Double& resol2,
		const SymMat43_Double& S_red)
	: 	m_resol2(resol2),
		m_S_red( S_red )
{
	SymMat<Double> S_super_obtuse = transform_sym_matrix(m_S_red.second, m_S_red.first);
	assert( S_super_obtuse(0,1) <= 1.0e-15
			&& S_super_obtuse(0,2) <= 1.0e-15
			&& S_super_obtuse(0,3) <= 1.0e-15
			&& S_super_obtuse(1,2) <= 1.0e-15
			&& S_super_obtuse(1,3) <= 1.0e-15
			&& S_super_obtuse(2,3) <= 1.0e-15 );
	put_S_super_obtuse_equiv( S_super_obtuse, resol2, m_S_super_obtuse_equiv );
	
}


ReducedLatticeToCheckEquiv::~ReducedLatticeToCheckEquiv()
{
}


bool ReducedLatticeToCheckEquiv::equiv(const SymMat<Double>& S_super_obtuse) const
{
	assert( S_super_obtuse.size() == 4 );

	for(vector< SymMat<Double> >::const_iterator it=m_S_super_obtuse_equiv.begin(); it<m_S_super_obtuse_equiv.end(); it++)
	{
		if( check_equiv_s(*it, S_super_obtuse, m_resol2) )
		{
			return true;
		}
	}
	return false;
}
