%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Introduction</title>
@y
  <title>はじめに</title>
@z

@x
  <para>This chapter shows you how to create cross platform tools.</para>
@y
  <para>
  本章はクロスプラットフォームツールの生成方法について説明します。
  </para>
@z

@x
  <para>If for some reason you have to stop and come back later, remember
  to use the <command>su - clfs</command> command, and it will setup the
  build environment that you left.</para>
@y
  <para>
  何かの都合によりいったん作業中断し再度ここに戻ってきた場合には <command>su - clfs</command> コマンドを実行することを忘れないでください。
  このコマンドにより、ビルド環境の設定を元に戻すことができます。
  </para>
@z

@x
    <title>Common Notes</title>
@y
    <title>共通メモ</title>
@z

@x
      <para>Before issuing the build instructions for a package, the package
      should be unpacked, and a <command>cd</command> into the created
      directory should be performed.</para>
@y
      <para>
      パッケージのビルド手順においては、必ずそのパッケージを伸張 (解凍) して <command>cd</command> コマンドによってそのパッケージのディレクトリに移動してください。
      作業はそのディレクトリ内にて行います。
      </para>
@z

@x
    <para>Several of the packages are patched before compilation, but only
    when the patch is needed to circumvent a problem. A patch is often needed
    in both this and the next chapters, but sometimes in only one or the other.
    Therefore, do not be concerned if instructions for a downloaded patch seem
    to be missing. Warning messages about <emphasis>offset</emphasis> or
    <emphasis>fuzz</emphasis> may also be encountered when applying a patch.
    Do not worry about these warnings, as the patch was still successfully
    applied.</para>
@y
    <para>
    パッケージの中には、コンパイルする前にパッチを当てるものがあります。
    パッチを当てるのは、そのパッケージが抱える問題を回避するためです。
    本章と次章の双方でパッチを当てるものがあり、あるいは本章と次章のいずれか一方でパッチを当てるものもあります。
    したがってパッチをダウンロードする説明が書かれていないなら、何も気にせず先に進んでください。
    パッチを当てた際に <emphasis>offset</emphasis> や <emphasis>fuzz</emphasis> といった警告メッセージが出る場合がありますが、これらは気にしないでください。
    このような時でもパッチは問題なく適用されています。
    </para>
@z

@x
    <para>During the compilation of most packages, there will be several
    warnings that scroll by on the screen. These are normal and can safely
    be ignored. These warnings are as they appear&mdash;warnings about
    deprecated, but not invalid, use of the C or C++ syntax. C standards
    change fairly often, and some packages still use the older standard.
    This is not a problem, but does prompt the warning.</para>
@y
    <para>
    コンパイルの最中に、警告メッセージが画面上に出力されることがよくあります。
    これは問題はないため無視して構いません。
    警告メッセージは、メッセージ内に説明されているように、C や C++ の文法が誤りではないものの推奨されていないものであることを示しています。
    C 言語の標準はよく変更されますが、パッケージの中には古い基準に従っているものもあります。
    問題はないのですが、警告として画面表示されることになるわけです。
    </para>
@z

@x
      <para>After installing each package, both in this and the next chapters,
      delete its source and build directories, unless specifically instructed
      otherwise. Deleting the sources prevents mis-configuration
      when the same package is reinstalled later.</para>
@y
      <para>
      個々のパッケージをインストールし終えたら、特に指示がない限りはソースディレクトリとビルドディレクトリを削除してください。
      ソースを削除しておけば、再びインストール作業を行うような場合に、無用な作業不備を避けることができます。
      </para>
@z
