%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Making the Temporary System Bootable</title>
@y
  <title>一時システムのブート設定</title>
@z

@x
    <secondary>boot, configuring</secondary>
@y
    <secondary>ブート, 設定</secondary>
@z

@x
  <para os="a">Some of the idiosyncracies of booting on ppc are discussed in
   <xref linkend="appendixe" role="."/>. Essentially, there are two options
   here - either copy the bootloader to an  OSX root partition and boot from
   Open Firmware, or use an install, Live, or rescue CD to set up a bootstrap
   partition.</para>
@y
  <para os="a">
   PPC におけるブート処理の特異性については <xref linkend="appendixe" role=""/> において示しています。
   ブート設定については二通りのやり方があります。
   一つはブートローダーを OSX ルートパーティションにコピーして Open Firmware により起動する方法。
   もう一つはライブCD、レスキューCD などを用いてブートストラップ (bootstrap) パーティションを設定する方法です。
  </para>
@z

@x
    <title>Copying the bootloader to OSX and booting from OF.</title>
@y
    <title>OSX へのブートローダーのコピー、Open Firmware による起動</title>
@z

@x
    <para os="b">You must now ensure that <filename>/tools/etc/yaboot.conf</filename>
    contains the correct details for the CLFS system.  Consult
    <xref linkend="ch-bootable-yaboot" role="."/> for details, but note that
    at this point you do not need the <literal>install, magicboot, enablecdboot
    </literal>or <literal>macosx</literal> parameters because these are not
    available when you boot from Open Firmware.</para>
@y
    <para os="b">
    <filename>/tools/etc/yaboot.conf</filename> ファイルには CLFS システムに対する設定が正しく含まれていなければなりません。
    詳しくは <xref linkend="ch-bootable-yaboot" role=""/> を確認してください。
    ただしこの時点においては <literal>install, magicboot, enablecdboot</literal> パラメーターや <literal>macosx</literal> パラメーターは必要ありません。
    Open Firmware からブートする場合はそれらのパラメーターは用いられないからです。
    </para>
@z

@x
    <para os="c">By this stage, you should have the temporary system on an ext2
    filesystem on your Mac.  Now, from within OSX, copy
    <filename>/tools/lib/yaboot/yaboot</filename>) and
    <filename>/tools/etc/yaboot.conf</filename>) to the OSX <filename>/</filename>
    directory.</para>
@y
    <para os="c">
    この段階においては Mac コンピューターの ext2 ファイルシステム上に一時システムが存在しているはずです。
    ここで OSX 内から <filename>/tools/lib/yaboot/yaboot</filename> と <filename>/tools/etc/yaboot.conf</filename> を OSX のルートパーティション <filename>/</filename> にコピーします。
    </para>
@z

@x
   <para os="d">Each time you want to boot into the temporary system, hold down
   the option-command-o-f keys to get to Open Firmware, then use the following
   command, replacing <literal>X</literal> with the number of the partition
   containing the <emphasis>OSX</emphasis> root filesystem (typically, this
   will be '3').</para>
@y
   <para os="d">
   一時システムを再度起動させたい場合は option + command + o + f を同時押しすることで Open Firmware を起動します。
   そして以下のコマンドを実行してください。
   なお <literal>X</literal> の部分は <emphasis>OSX</emphasis> ルートファイルシステムがあるパーティション番号に置き換えてください。
   (通常 '3' であるはずです。)
   </para>
@z

@x
    <title>Using a CD to set up the bootstrap partition.</title>
@y
    <title>CD を用いたブートストラップパーティションの設定</title>
@z

@x
    <para os="f">This is particularly appropriate if you cannot write to an
    ext2 filesystem from OSX. Boot from the CD, and (as necessary) create
    partitions and filesystems, mount the CLFS partition at
    <filename>/tools</filename>  and untar the temporary system there.</para>
@y
    <para os="f">
    OSX から ext2 ファイルシステムを書き込むことができない場合には、この方法を取ります。
    CD から起動して (必要ならば) パーティションやファイルシステムを生成します。
    そして <filename>/tools</filename> に CLFS パーティションをマウントして、ここに一時システムを伸張 (解凍) します。
    </para>
@z

@x
    <para os="g">Now set up <filename>/tools/etc/yaboot.conf</filename> - see
    <xref linkend="ch-bootable-yaboot" role="."/> for details of what should be
    in it, but note that the <emphasis>install</emphasis> and <emphasis>magicboot
    </emphasis>specifications should point to<filename>/tools/lib/yaboot/</filename>
    and <emphasis>not</emphasis> <filename>/usr/lib/yaboot</filename>.</para>
@y
    <para os="g">
    まず <filename>/tools/etc/yaboot.conf</filename> を設定します。
    何を設定すべきかについての詳細は <xref
    linkend="ch-bootable-yaboot" role=""/> を参照してください。
    気をつけるべき点として、<emphasis>install</emphasis> と <emphasis>magicboot</emphasis> はそれぞれ
    <filename>/tools/lib/yaboot/</filename> を設定すべきであって <filename>/usr/lib/yaboot</filename> では<emphasis>ありません</emphasis>。
    </para>
@z

@x
    <para os="h">To write the bootloader to the disk, with <filename>/tools/sbin
   </filename>first on your path and <filename>/proc</filename> mounted, run the
   following command:</para>
@y
    <para os="h">
    ディスクにブートローダーを書き込むには、まずパス設定に <filename>/tools/sbin</filename> を加えた上で <filename>/proc</filename> をマウントし、以下のコマンドを実行します。
    </para>
@z