%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>To Boot or to Chroot?</title>
@y
  <title>再起動か chroot か？</title>
@z

@x
  <para os="a">There are two different ways you can proceed from this point
  to build the final system. You can build a kernel, a bootloader, and
  a few other utilities, boot into the temporary system, and build the
  rest there. Alternatively, you can mount a few virtual filesystems and
  chroot into the temporary system.</para>
@y
  <para os="a">
  最終的なシステム構築にあたり、ここから先に進む方法が二通りあります。
  一つはカーネル、ブートローダー、ユーティリティーのビルドを行い、一時システムを再起動 (ブート) した上で、残るプログラム類をビルドしていく方法です。
  もう一つは、必要な仮想ファイルシステムをマウントして chroot により一時システムに入って作業を進めるものです。
  </para>
@z

@x
  <para os="b">The <command>chroot</command> (change root) program is used to
  enter a virtual environment and start a new shell whose root directory will
  be set to the CLFS partition. This is very similar to rebooting and
  instructing the kernel to mount the CLFS partition as the root partition.
  The major advantage is that <quote>chrooting</quote> allows the builder to
  continue using the host while CLFS is being built. While waiting for package
  compilation to complete, a user can switch to a different virtual console
  (VC) or X desktop and continue using the computer as normal.</para>
@y
  <para os="b">
  <command>chroot</command> (チェンジルート; change root) プログラムは仮想的な環境に入って新たなシェルを起動するものです。
  このときのルートディレクトリは CLFS パーティションに設定します。
  このことは、システムを再起動してカーネルに対し CLFS パーティションをルートパーティションとする処理と極めて似ています。
  ただ<quote>chrootする</quote>ことの最大のメリットは、ホスト環境を利用して引き続き CLFS ビルド作業を行える点にあります。
  この方法であればパッケージのビルド途中であっても他の仮想端末 (virtual console; vc) や X デスクトップに切り替えて、普段どおりにコンピューター作業を行うこともできます。
  </para>
@z

@x
  <para os="c">The main downside to chrooting is that you are more limited in
  when you can use it - booting will always work for any CLFS build, but the
  chroot method can only be used when you are building on the same
  architecture. For example, if you are building on, and for, an x86 system,
  you can simply chroot. Booting is required when you are compiling for a
  different architecture, such as building a PowerPC system from an x86. The
  rule of thumb here is that if the architectures match and you are running
  the same series kernel (specifically, a &glibc-kernel-version; or newer
  Linux kernel) you can just chroot. If you aren't running the same series
  kernel, or are wanting to run a different ABI, you will need to use the boot
  option.</para>
@y
  <para os="c">
  chrootする方法にも欠点があり、利用は限定的にならざるをえません。
  再起動する方法はどのような CLFS ビルドであっても採用できますが、chrootする方法は同一のアーキテクチャーのものしか構築できません。
  例えば x86 システム上に x86 システムを構築しようとするなら単純に chrootする方法で構いません。
  再起動する方法は異なるアーキテクチャー、例えば x86 システムから PowerPC システムをビルドする場合などに用います。
  さらに大雑把に言えば、同一アーキテクチャーであり同一シリーズのカーネル (特に &glibc-kernel-version; 以上 の Linux カーネル) であるなら chrootする方法を選びます。
  同一シリーズのカーネルではなく、あるいは異なる ABI であるなら再起動する方法を選びます。
  </para>
@z

@x
  <para os="d">If you are in any doubt about this, you can try the following
  commands to see if you can chroot:</para>
@y
  <para os="d">
  上の説明に不安を感じるようであれば、以下のコマンドを実行してみてください。
  このコマンドにより chroot できるかどうかが分かります。
  </para>
@z

@x
  <para os="f">If either of these commands fail, you will have to follow the
  boot method.</para>
@y
  <para os="f">
  上のコマンドが一つでも失敗したら、再起動する方法を取らなければなりません。
  </para>
@z

@x
  <para os="g">For the boot method, follow <xref linkend="chapter-boot"/>.</para>
@y
  <para os="g">
  再起動する方法は<xref linkend="chapter-boot"/>に進んでください。
  </para>
@z

@x
  <para os="h">For the chroot method, follow <xref linkend="chapter-chroot"/>.</para>
@y
  <para os="h">
  chroot する方法は<xref linkend="chapter-chroot"/>に進んでください。
  </para>
@z