%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>temporary system</secondary>
@y
    <secondary>&TemporarySystem;</secondary>
@z

@x
    <title>Installation of Bash</title>
@y
    <title>&InstallationOf1;Bash &InstallationOf2;</title>
@z

@x
    <para os="t1">When Bash is cross-compiled, it cannot test for the presence
    of named pipes, among other things. If you used <command>su</command> to
    become an unprivileged user, this combination will cause Bash to build
    without <emphasis>process substitution</emphasis>, which will break one
    of the C++ test scripts in <literal>glibc</literal>. The following prevents
    future problems by skipping the check for named pipes, as well as other
    tests that can not run while cross-compiling or that do not run properly:</para>
@y
    <para os="t1">
    Bash をクロスコンパイルする場合、名前付きパイプ (named pipes) などが利用されていることをテストすることができません。
    <command>su</command> を使って一般ユーザーになっているとき、Bash のビルド結果には <emphasis>プロセス置換 (process substitution)</emphasis> が含まれなくなります。
    そうなると <literal>glibc</literal> での C++ テストスクリプトが不具合を起こします。
    以下を設定することによって、名前付きパイプなどのチェックをスキップしこの後に引き起こされる不具合を回避します。
    こうすることでクロスコンパイル時にテストできなかったり正常動作しなかったりすることがなくなります。
    </para>
@z

@x
      <title>The meaning of the new configure option:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --without-bash-malloc
          <para>This option turns off the use of Bash's memory allocation
          (malloc) function which is known to cause segmentation faults.
          By turning this option off, Bash will use the malloc functions
          from Glibc which are more stable.</para>
@y
          <para>
          このオプションは Bash のメモリ割り当て (memory allocation; malloc) 関数の利用を停止します。
          この機能はセグメンテーションフォールトを発生させることがあります。
          利用を停止することで Bash は Glibc の malloc 関数を用いるようになり、こちらの方が安定しています。
          </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-bash" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-bash" role=""/>&Details2;
    </para>
@z