%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Foreword</title>
@y
  <title>はじめに</title>
@z

@x
  <para>The Linux From Scratch Project has seen many changes in the
  few years of its existence.  I personally became involved with the
  project in 1999, around the time of the 2.x releases.  At that time,
  the build process was to create static binaries with the host system,
  then chroot and build the final binaries on top of the static ones.</para>
@y
  <para>
  Linux From Scratch プロジェクトはここ数年において大きく変化しています。
  私個人が参加した時期は 1999年であり 2.x がリリースされていた頃です。
  その頃のビルド方法と言えば、ホストシステム上にスタティックライブラリを生成し
  chroot を用いてそのスタティックライブラリに基づく最終的な実行モジュールを作り上げるものでした。
  </para>
@z

@x
  <para>Later came the use of the /static directory to hold the initial
  static builds, keeping them separated from the final system, then
  the PureLFS process developed by Ryan Oliver and Greg Schafer,
  introducing a new toolchain build process that divorces even our initial
  builds from the host.  Finally, LFS 6 brought Linux Kernel 2.6, the
  udev dynamic device structure, sanitized kernel headers, and other
  improvements to the Linux From Scratch system.</para>
@y
  <para>
  後に /static ディレクトリは初期のスタティックライブラリのビルドにおいてのみ用いられるようになります。
  それは最終システムとは切り離され、Ryan Oliver と
  Greg Schafer により開発された PureLFS に基づく作業を通じて新たなツールチェーンの構築作業に入ります。
  この作業段階においては、ホストシステムを用いた初期段階でのビルド作業とは完全に離れます。
  最終的に LFS バージョン 6 にて Linux カーネル 2.6、udev による動的デバイス構成、健全化されたカーネルヘッダーといった種々の改善が Linux From Scratch システムに組み入れられます。
  </para>
@z

@x
  <para>The one "flaw" in LFS is that it has always been based on an x86
  class processor.  With the advent of the Athlon 64 and Intel EM64T
  processors, the x86-only LFS is no longer ideal. Throughout this time,
  Ryan Oliver developed and documented a process by which you could
  build Linux for any system and from any system, by use of
  cross-compilation techniques.  Thus, the Cross-Compiled LFS (CLFS) was
  born.</para>
@y
  <para>
  LFS における一つの "欠点" は常に x86系のプロセッサーを対象としていたことです。
  Athlon 64 プロセッサーや Intel EM64T プロセッサーが登場してくると、x86 だけを取り扱っている LFS が理想形でなくなってしまいました。
  このようなときに Ryan Oliver が Linux を構築する新たな作業手順を開発しドキュメント化します。
  その手順はターゲットとするシステムもホストとするシステムも何でもよく、クロスコンパイルの手法を用いたものです。
  こうしてクロスコンパイル LFS (CLFS) が誕生しました。
  </para>
@z

@x
  <para>CLFS follows the same guiding principles the LFS project has
  always followed, e.g., knowing your system inside and out by virtue
  of having built the system yourself.  Additionally, during a CLFS
  build, you will learn advanced techniques such as cross-build toolchains,
  multilib support (32 &amp; 64-bit libraries side-by-side), alternative
  architectures such as Sparc, MIPS, and much more.</para>
@y
  <para>
  CLFS は LFS プロジェクトが常に採用してきた原則に従っています。
  それは自分自身でシステムを構築していくことを通じ、システムの内部を隅々まで学ぶという姿勢です。
  CLFS の作業はそれにとどまらず、応用技術としてクロスビルドによるツールチェーンやマルチライブラリ (32ビット、64ビットのライブラリ) サポートを学ぶことができます。
  さらには対象とするアーキテクチャーも Sparc や MIPS とすることも出来、学ぶ範囲はさらに広がっています。
  </para>
@z

@x
  <para>We hope you enjoy building your own CLFS system, and the benefits
  that come from a system tailored to your needs.</para>
@y
  <para>
  CLFS システム作りを楽しんでください。
  また必要に応じて作り上げたシステムが役立つことを望みます。
  </para>
@z

@x
<literallayout>--
Jeremy Utley, CLFS 1.x Release Manager (Page Author)
Jonathan Norman, Release Manager
Jim Gifford, CLFS Project Co-leader
Ryan Oliver, CLFS Project Co-leader
Joe Ciccone, CLFS Project Co-leader
Jonathan Norman, Justin Knierim, Chris Staub, Matt Darcy, Ken Moffat,
Manuel Canales Esparcia, Nathan Coulson and William Harrington - CLFS Developers</literallayout>
@y
<literallayout>--
Jeremy Utley, CLFS 1.x リリースマネージャー (ページ作成者)
Jonathan Norman, リリースマネージャー
Jim Gifford, CLFS プロジェクト共同リーダー
Ryan Oliver, CLFS プロジェクト共同リーダー
Joe Ciccone, CLFS プロジェクト共同リーダー
Jonathan Norman, Justin Knierim, Chris Staub, Matt Darcy, Ken Moffat,
Manuel Canales Esparcia, Nathan Coulson, William Harrington - CLFS 開発者</literallayout>
@z