%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Bootscripts for CLFS &bootscripts-clfs-version;</title>
@y
  <title>CLFS &bootscripts-clfs-version; 用の Bootscripts</title>
@z

@x
    <secondary>boot</secondary>
@y
    <secondary>ブート</secondary>
@z

@x
    <para>The Bootscripts package contains a set of scripts to
    start/stop the CLFS system at bootup/shutdown.</para>
@y
    <para>
    Bootscripts パッケージは CLFS システムの起動、終了とともに実行する一連のスクリプトを提供します。
    </para>
@z

@x
    <title>Installation of Bootscripts</title>
@y
    <title>&InstallationOf1;Bootscripts &InstallationOf2;</title>
@z

@x
    <para os="p1">Apply a patch which modifies the scripts for use in
    <filename class="directory">/tools</filename>:</para>
@y
    <para os="p1">
    以下のパッチを適用して各スクリプトを <filename
    class="directory">/tools</filename> 内で用いるようにします。
    </para>
@z

@x
    <para os="a">Install the package:</para>
@y
    <para os="a">&InstallThePackage;</para>
@z

@x
  <para os="c">The <command>setclock</command> script reads the time from the
  hardware clock, also known as the BIOS or the Complementary Metal Oxide
  Semiconductor (CMOS) clock. If the hardware clock is set to UTC, this
  script will convert the hardware clock's time to the local time using
  the <filename>/tools/etc/sysconfig/clock</filename> file (which tells the
  <command>hwclock</command> program which timezone the user is in). There
  is no way to detect whether or not the hardware clock is set to UTC, so
  this needs to be configured manually.</para>
@y
  <para os="c">
  <command>setclock</command> スクリプトはハードウェアクロックから時刻を読み取ります。
  ハードウェアクロックは BIOS クロック、あるいは CMOS (Complementary Metal Oxide Semiconductor) クロックとしても知られているものです。
  ハードウェアクロックが UTC に設定されていると <command>setclock</command> スクリプトは <filename>/etc/localtime</filename> ファイルを参照して、ハードウェアクロックの示す時刻をローカル時刻に変換します。
  <filename>/etc/localtime</filename> ファイルは <command>hwclock</command> プログラムに対して、ユーザーがどのタイムゾーンに位置するかを伝えます。
  ハードウェアクロックが UTC に設定されているかどうかを知る方法はないので、手動で設定を行う必要があります。
  </para>
@z

@x
  <para os="d">If you do not know whether or not the hardware clock is set to UTC,
  you can find out after you have booted the new machine by running the
  <userinput>hwclock --localtime  --show</userinput> command, and if
  necessary editing the <filename>/tools/etc/sysconfig/clock</filename> file.
  The worst that will happen if you make a wrong guess here is that the
  time displayed will be wrong.</para>
@y
  <para os="d">
  ハードウェアクロックが UTC に設定されているかどうか分からない場合は、新たなシステムの起動後に <userinput>hwclock --localtime --show</userinput> を実行すれば確認できます。
  必要なら <filename>/tools/etc/sysconfig/clock</filename> ファイルを編集してください。
  ここで設定した内容に誤りがあれば表示される時刻表示が誤ったものとなります。
  </para>
@z

@x
  <para os="e">Change the value of the <envar>UTC</envar> variable below
  to a value of <option>0</option> (zero) if the hardware clock
  is <emphasis>not</emphasis> set to UTC time.</para>
@y
  <para os="e">
  ハードウェアクロックが UTC 時刻として設定<emphasis>されていない</emphasis>場合は、以下に示す変数 <envar>UTC</envar> の値を <parameter>0</parameter> (ゼロ) にしてください。
  </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-bootscripts" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-bootscripts" role=""/>&Details2;
    </para>
@z