/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.colormodel.ColorModels;
import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayersTableModel
extends AbstractTableModelWithComboBoxModel<LayersTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LayersTableModel.class.getName());
    private static final String[] layerColumnNames;
    private static final int[] layersColumnWidths;
    private int serialCounter = 1;

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < layersColumnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(layersColumnWidths[idx]);
        }
    }

    public void addNewLayer() {
        LayersTableRow layer = new LayersTableRow();
        String layerId = "lay" + UUID.randomUUID().toString();
        String layerName = "Layer" + this.serialCounter++;
        layer.setLayerId(layerId);
        layer.setLayerName(layerName);
        this.addRow(layer);
    }

    @Override
    public int getColumnCount() {
        return layerColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return layerColumnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LayersTableRow layer = (LayersTableRow)this.elements.get(rowIndex);
        Columns column = Columns.values()[columnIndex];
        return column.getValue(layer);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LayersTableRow layer = (LayersTableRow)this.elements.get(rowIndex);
        try {
            Columns column = Columns.values()[columnIndex];
            if (column.setValue(layer, aValue)) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns column = Columns.values()[columnIndex];
        return column.getColumnClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable();
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<LayersTableRow>(){

            @Override
            public int compare(LayersTableRow o1, LayersTableRow o2) {
                CategoriesTableRow p2;
                CategoriesTableRow p1 = o1.getPartsCategory();
                int ret = p1 == (p2 = o2.getPartsCategory()) ? 0 : (p1 != null && p2 != null ? p1.compareTo(p2) : (p1 == null ? -1 : 1));
                if (ret == 0) {
                    ret = o1.getOrder() - o2.getOrder();
                }
                if (ret == 0) {
                    ret = o1.getLayerId().compareTo(o2.getLayerId());
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    protected boolean isUsed(ColorGroupsTableRow colorGroup) {
        if (colorGroup != null) {
            for (LayersTableRow layer : this.elements) {
                if (!ColorGroupsTableRow.equals(layer.getColorGroup(), colorGroup)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUsed(CategoriesTableRow partsCategory) {
        if (partsCategory != null) {
            for (LayersTableRow layer : this.elements) {
                if (!CategoriesTableRow.equals(layer.getPartsCategory(), partsCategory)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/profileditdialog");
        int columnsLen = Columns.values().length;
        layerColumnNames = new String[columnsLen];
        layersColumnWidths = new int[columnsLen];
        for (Columns column : Columns.values()) {
            try {
                LayersTableModel.layerColumnNames[column.ordinal()] = strings.getProperty(column.getResourceKey());
                LayersTableModel.layersColumnWidths[column.ordinal()] = Integer.parseInt(strings.getProperty(column.getResourceKey() + ".width"));
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, "resource not found. related=" + (Object)((Object)column), ex);
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Columns {
        LAYER_NAME("layers.column.layername", (Class)String.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getLayerName();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setLayerName((String)aValue);
                return true;
            }
        }
        ,
        CATEGORY("layers.column.category", (Class)CategoriesTableRow.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getPartsCategory();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setPartsCategory((CategoriesTableRow)aValue);
                return true;
            }
        }
        ,
        COLOR_GROUP("layers.column.colorgroup", (Class)ColorGroupsTableRow.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getColorGroup();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setColorGroup((ColorGroupsTableRow)aValue);
                return true;
            }
        }
        ,
        ORDER("layers.column.order", (Class)Integer.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getOrder();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setOrder(((Number)aValue).intValue());
                return true;
            }
        }
        ,
        COLOR_MODEL("layers.column.colorModel", (Class)ColorModels.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getColorModel();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setColorModel((ColorModels)aValue);
                return true;
            }
        }
        ,
        DIRECTORY("layers.column.directory", (Class)String.class){

            public Object getValue(LayersTableRow layer) {
                return layer.getDir();
            }

            public boolean setValue(LayersTableRow layer, Object aValue) {
                layer.setDir((String)aValue);
                return true;
            }
        };

        private final String resourceKey;
        private final Class<?> typ;

        private Columns(String resourceKey, Class<?> typ) {
            this.resourceKey = resourceKey;
            this.typ = typ;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public Class<?> getColumnClass() {
            return this.typ;
        }

        public abstract Object getValue(LayersTableRow var1);

        public abstract boolean setValue(LayersTableRow var1, Object var2);
    }
}

