/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorCoordinator {
    private static final Logger logger = Logger.getLogger(PartsColorCoordinator.class.getName());
    private IdentityHashMap<ImageSelectPanel, ColorDialog> colorDialogMap = new IdentityHashMap();
    private PartsColorManager partsColorMrg;
    private PartsSpecResolver partsSpecResolver;
    private ColorGroupCoordinator colorGroupCoordinator;

    public PartsColorCoordinator(PartsSpecResolver partsSpecResolver, PartsColorManager partsColorMrg, ColorGroupCoordinator colorGroupCoordinator) {
        if (partsSpecResolver == null || partsColorMrg == null || colorGroupCoordinator == null) {
            throw new IllegalArgumentException();
        }
        this.partsSpecResolver = partsSpecResolver;
        this.partsColorMrg = partsColorMrg;
        this.colorGroupCoordinator = colorGroupCoordinator;
    }

    public void register(final ImageSelectPanel imageSelectPanel, final ColorDialog colorDialog) {
        if (imageSelectPanel == null || colorDialog == null) {
            throw new IllegalArgumentException();
        }
        if (this.colorDialogMap.containsKey(imageSelectPanel)) {
            throw new IllegalArgumentException("already registered: " + imageSelectPanel);
        }
        this.colorDialogMap.put(imageSelectPanel, colorDialog);
        imageSelectPanel.addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

            public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent event) {
            }

            public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent event) {
            }

            public void onChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                PartsColorCoordinator.this.loadColorSettingToColorDialog(imageSelectPanel, colorDialog);
            }

            public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                PartsColorCoordinator.this.loadColorSettingToColorDialog(imageSelectPanel, colorDialog);
            }

            public void onTitleClick(ImageSelectPanel.ImageSelectPanelEvent event) {
            }

            public void onTitleDblClick(ImageSelectPanel.ImageSelectPanelEvent event) {
            }
        });
        colorDialog.addColorChangeListener(new ColorChangeListener(){

            public void onColorChange(ColorChangeEvent event) {
                PartsColorCoordinator.this.saveColorSettingAll();
            }

            public void onColorGroupChange(ColorChangeEvent event) {
                PartsColorCoordinator.this.saveColorSettingAll();
            }
        });
    }

    protected void loadColorSettingToColorDialog(ImageSelectPanel imageSelectPanel, ColorDialog colorDialog) {
        PartsIdentifier selectedParts = imageSelectPanel.getSelectedPartsIdentifier();
        colorDialog.setPartsIdentifier(selectedParts);
        colorDialog.setEnableLayers(this.getEnabledLayers(selectedParts));
        if (selectedParts == null) {
            return;
        }
        PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(selectedParts, false);
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            Layer layer = entry.getKey();
            ColorInfo colorInfo = entry.getValue();
            ColorGroup colorGroup = colorInfo.getColorGroup();
            if (colorGroup == null) {
                colorGroup = ColorGroup.NA;
            }
            colorDialog.setColorGroup(layer, colorGroup);
            boolean syncColorGroup = colorInfo.isSyncColorGroup();
            colorDialog.setSyncColorGroup(layer, syncColorGroup);
            ColorConvertParameter param = colorInfo.getColorParameter();
            colorDialog.setColorConvertParameter(layer, param);
            if (!syncColorGroup) continue;
            this.colorGroupCoordinator.syncColorGroup(colorDialog.getPartsCategory(), layer, colorDialog);
        }
    }

    protected void saveColorSettingAll() {
        for (Map.Entry<ImageSelectPanel, ColorDialog> entry : this.colorDialogMap.entrySet()) {
            ImageSelectPanel imageSelectPanel = entry.getKey();
            ColorDialog colorDialog = entry.getValue();
            this.saveColorSettingFromColorDialog(imageSelectPanel, colorDialog);
        }
    }

    protected void saveColorSettingFromColorDialog(ImageSelectPanel imageSelectPanel, ColorDialog colorDialog) {
        PartsIdentifier selectedParts = imageSelectPanel.getSelectedPartsIdentifier();
        if (selectedParts == null) {
            return;
        }
        Map<Layer, ColorConvertParameter> paramMap = colorDialog.getColorConvertParameters();
        PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(selectedParts, true);
        for (Map.Entry<Layer, ColorConvertParameter> entry : paramMap.entrySet()) {
            Layer layer = entry.getKey();
            ColorConvertParameter param = entry.getValue();
            ColorInfo colorInfo = new ColorInfo();
            ColorGroup colorGroup = colorDialog.getColorGroup(layer);
            colorInfo.setColorGroup(colorGroup);
            boolean syncColorGroup = colorDialog.isSyncColorGroup(layer);
            colorInfo.setSyncColorGroup(syncColorGroup);
            colorInfo.setColorParameter(param);
            partsColorInfo.put(layer, colorInfo);
        }
        boolean applyAll = colorDialog.isApplyAll();
        this.partsColorMrg.setPartsColorInfo(selectedParts, partsColorInfo, applyAll);
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameterMap() {
        HashMap<Layer, ColorConvertParameter> colorConvertParameterMap = new HashMap<Layer, ColorConvertParameter>();
        for (ColorDialog colorDlg : this.colorDialogMap.values()) {
            for (Map.Entry<Layer, ColorConvertParameter> entry : colorDlg.getColorConvertParameters().entrySet()) {
                Layer layer = entry.getKey();
                ColorConvertParameter colorConvertParameter = entry.getValue();
                colorConvertParameterMap.put(layer, colorConvertParameter);
            }
        }
        return colorConvertParameterMap;
    }

    public void initColorDialog() {
        for (Map.Entry<ImageSelectPanel, ColorDialog> entry : this.colorDialogMap.entrySet()) {
            ImageSelectPanel imageSelectPanel = entry.getKey();
            ColorDialog colorDialog = entry.getValue();
            PartsIdentifier partsIdentifier = imageSelectPanel.getSelectedPartsIdentifier();
            colorDialog.setPartsIdentifier(partsIdentifier);
            colorDialog.setEnableLayers(this.getEnabledLayers(partsIdentifier));
            if (partsIdentifier == null) continue;
            PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
            for (Map.Entry<Layer, ColorInfo> colorInfoEntry : partsColorInfo.entrySet()) {
                Layer layer = colorInfoEntry.getKey();
                ColorInfo colorInfo = colorInfoEntry.getValue();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, layer + "=" + colorInfo);
                }
                colorDialog.setColorGroup(layer, colorInfo.getColorGroup());
                colorDialog.setSyncColorGroup(layer, colorInfo.isSyncColorGroup());
                colorDialog.setColorConvertParameter(layer, colorInfo.getColorParameter());
            }
        }
    }

    protected Collection<Layer> getEnabledLayers(PartsIdentifier partsIdentifier) {
        AppConfig appConfig = AppConfig.getInstance();
        if (appConfig.isNotDisableLayerTab()) {
            return null;
        }
        if (partsIdentifier != null) {
            PartsSpec partsSpec = this.partsSpecResolver.getPartsSpec(partsIdentifier);
            ArrayList<Layer> layers = new ArrayList<Layer>();
            if (partsSpec != null) {
                for (Layer layer : partsSpec.getPartsFiles().keySet()) {
                    layers.add(layer);
                }
            }
            return layers;
        }
        return null;
    }
}

