/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Wallpaper {
    private static final Logger logger = Logger.getLogger(Wallpaper.class.getName());
    private static final int wallpaperPreferredWidth = 128;
    private static final int wallpaperPreferredHeight = 128;
    public static final String KEY_WALLPAPER_IMAGE = "wallpaperImage";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Color backgroundColor = Color.WHITE;
    private BufferedImage wallpaperImg;
    private float wallpaperAlpha = 1.0f;
    private VolatileImage wallpaperVolatileImg;
    private Color wallpaperVolatileBgColor;

    public Wallpaper() {
        this(null);
    }

    public Wallpaper(BufferedImage wallpaperImg) {
        this.wallpaperImg = this.makeExpandedWallpaper(this.makeExpandedWallpaper(wallpaperImg));
    }

    public void setWallpaperImage(BufferedImage wallpaperImg) {
        this.disposeOffscreen();
        BufferedImage wallpaperImgOld = this.makeExpandedWallpaper(this.wallpaperImg);
        this.wallpaperImg = this.makeExpandedWallpaper(wallpaperImg);
        this.propertyChangeSupport.firePropertyChange(KEY_WALLPAPER_IMAGE, wallpaperImgOld, this.wallpaperImg);
    }

    public BufferedImage getWallpaperImage() {
        return this.wallpaperImg;
    }

    public float getWallpaperAlpha() {
        return this.wallpaperAlpha;
    }

    public void setWallpaperAlpha(float wallpaperAlpha) {
        this.disposeOffscreen();
        if (wallpaperAlpha < 0.0f) {
            wallpaperAlpha = 0.0f;
        } else if (wallpaperAlpha > 1.0f) {
            wallpaperAlpha = 1.0f;
        }
        float oldalpha = this.wallpaperAlpha;
        if (oldalpha != wallpaperAlpha) {
            this.wallpaperAlpha = wallpaperAlpha;
            this.propertyChangeSupport.firePropertyChange("wallpaperAlpha", Float.valueOf(oldalpha), Float.valueOf(wallpaperAlpha));
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color colorOld;
        this.disposeOffscreen();
        if (backgroundColor == null) {
            backgroundColor = Color.WHITE;
        }
        if (!(colorOld = this.backgroundColor).equals(backgroundColor)) {
            this.backgroundColor = backgroundColor;
            this.propertyChangeSupport.firePropertyChange("backgroundColor", colorOld, backgroundColor);
        }
    }

    public void drawWallpaper(Graphics2D g, int w, int h) {
        this.drawWallpaper(g, w, h, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawWallpaper(Graphics2D g, int w, int h, boolean noUseOffscreen) {
        Color bgColor = this.getBackgroundColor();
        if (this.wallpaperImg == null) {
            this.fillBackgroundColor(g, bgColor, w, h);
        }
        if (this.wallpaperImg != null) {
            boolean drawOffscreen = false;
            if (!noUseOffscreen) {
                AppConfig appConfig = AppConfig.getInstance();
                if (appConfig.isEnableOffscreenWallpaper()) {
                    this.checkOrCreateOffscreen(g, bgColor, w, h);
                } else {
                    this.disposeOffscreen();
                }
                if (this.wallpaperVolatileImg != null) {
                    int src_w = this.wallpaperVolatileImg.getWidth();
                    int src_h = this.wallpaperVolatileImg.getHeight();
                    this.drawWallpaper(g, w, h, this.wallpaperVolatileImg, src_w, src_h);
                    boolean bl = drawOffscreen = !this.wallpaperVolatileImg.contentsLost();
                }
            }
            if (!drawOffscreen) {
                if (this.wallpaperVolatileImg != null && logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "offscreen is lost.");
                }
                this.fillBackgroundColor(g, bgColor, w, h);
                Composite oldcomp = g.getComposite();
                try {
                    float alpha = this.getWallpaperAlpha();
                    if (alpha < 1.0f) {
                        AlphaComposite comp = AlphaComposite.getInstance(3, alpha);
                        g.setComposite(comp);
                    }
                    int src_w = this.wallpaperImg.getWidth();
                    int src_h = this.wallpaperImg.getHeight();
                    this.drawWallpaper(g, w, h, this.wallpaperImg, src_w, src_h);
                }
                finally {
                    g.setComposite(oldcomp);
                }
            }
        }
    }

    protected void disposeOffscreen() {
        if (this.wallpaperVolatileImg != null) {
            this.wallpaperVolatileImg.flush();
            this.wallpaperVolatileImg = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u3092\u7834\u68c4\u3057\u307e\u3057\u305f\u3002");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOrCreateOffscreen(Graphics2D g, Color bgColor, int offscreen_max_w, int offscreen_max_h) {
        block21: {
            if (this.wallpaperImg == null) {
                this.disposeOffscreen();
                return;
            }
            try {
                GraphicsConfiguration gConf = g.getDeviceConfiguration();
                int validate = 2;
                if (this.wallpaperVolatileImg != null) {
                    validate = this.wallpaperVolatileImg.validate(gConf);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u306e\u72b6\u614b: " + validate);
                    }
                }
                if (validate == 0 && this.wallpaperVolatileBgColor != null && bgColor != null && !this.wallpaperVolatileBgColor.equals(bgColor)) {
                    validate = 1;
                }
                int src_w = this.wallpaperImg.getWidth();
                int src_h = this.wallpaperImg.getHeight();
                AppConfig appConfig = AppConfig.getInstance();
                int offscreen_w = appConfig.getOffscreenWallpaperSize();
                int offscreen_h = appConfig.getOffscreenWallpaperSize();
                offscreen_w = Math.max(src_w, Math.min(offscreen_max_w, offscreen_w));
                offscreen_h = Math.max(src_h, Math.min(offscreen_max_h, offscreen_h));
                int nx = (int)Math.ceil((double)offscreen_w / (double)src_w);
                int ny = (int)Math.ceil((double)offscreen_h / (double)src_h);
                offscreen_w = src_w * nx;
                offscreen_h = src_h * ny;
                if (validate == 0 || validate == 1) {
                    int currentOffW = Math.max(1, this.wallpaperVolatileImg.getWidth());
                    int currentOffH = Math.max(1, this.wallpaperVolatileImg.getHeight());
                    double ratioW = (double)offscreen_w / (double)currentOffW;
                    double ratioH = (double)offscreen_h / (double)currentOffH;
                    if (ratioW < 0.8 || ratioW > 1.2 || ratioH < 0.8 || ratioH > 1.2) {
                        validate = 2;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u30b5\u30a4\u30ba\u306e\u5909\u66f4\u304c\u5fc5\u8981\u3067\u3059\u3002: " + ratioW + "," + ratioH);
                        }
                    }
                }
                if (validate == 0) break block21;
                if (this.wallpaperVolatileImg == null || validate == 2) {
                    this.disposeOffscreen();
                    this.wallpaperVolatileImg = gConf.createCompatibleVolatileImage(offscreen_w, offscreen_h, 1);
                    if (this.wallpaperVolatileImg == null) {
                        logger.log(Level.INFO, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u30a4\u30e1\u30fc\u30b8\u306f\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u3092\u69cb\u7bc9\u3057\u307e\u3057\u305f\u3002(\u30b5\u30a4\u30ba:" + offscreen_w + "," + offscreen_h + ")");
                    }
                }
                if (this.wallpaperVolatileImg == null) break block21;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u306e\u63cf\u753b (\u30b5\u30a4\u30ba:" + offscreen_w + "," + offscreen_h + ")");
                }
                Graphics2D vg = this.wallpaperVolatileImg.createGraphics();
                try {
                    int ow = this.wallpaperVolatileImg.getWidth();
                    int oh = this.wallpaperVolatileImg.getHeight();
                    this.fillBackgroundColor(vg, bgColor, ow, oh);
                    Composite oldcomp = vg.getComposite();
                    try {
                        float alpha = this.getWallpaperAlpha();
                        if (alpha < 1.0f) {
                            AlphaComposite comp = AlphaComposite.getInstance(3, alpha);
                            vg.setComposite(comp);
                        }
                        this.drawWallpaper(vg, ow, oh, this.wallpaperImg, src_w, src_h);
                    }
                    finally {
                        vg.setComposite(oldcomp);
                    }
                }
                finally {
                    vg.dispose();
                }
                this.wallpaperVolatileBgColor = bgColor;
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, "\u30aa\u30d5\u30b9\u30af\u30ea\u30fc\u30f3\u30a4\u30e1\u30fc\u30b8\u306e\u751f\u6210\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
                this.disposeOffscreen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillBackgroundColor(Graphics2D g, Color bgColor, int w, int h) {
        if (bgColor == null) {
            return;
        }
        Color oldc = g.getColor();
        try {
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(0, 0, w, h);
            }
            g.setColor(bgColor);
            g.fill(clip);
        }
        finally {
            g.setColor(oldc);
        }
    }

    protected void drawWallpaper(Graphics2D g, int w, int h, Image wallpaperImg, int src_w, int src_h) {
        if (wallpaperImg == null) {
            return;
        }
        int nx = (int)Math.ceil((double)w / (double)src_w);
        int ny = (int)Math.ceil((double)h / (double)src_h);
        Rectangle clip = g.getClipBounds();
        Rectangle rct = new Rectangle(0, 0, src_w, src_h);
        for (int iy = 0; iy <= ny; ++iy) {
            for (int ix = 0; ix <= nx; ++ix) {
                rct.x = ix * src_w;
                rct.y = iy * src_h;
                if (clip != null && !clip.intersects(rct)) continue;
                g.drawImage(wallpaperImg, rct.x, rct.y, rct.x + rct.width, rct.y + rct.height, 0, 0, src_w, src_h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage makeExpandedWallpaper(BufferedImage wallpaper) {
        if (wallpaper == null) {
            return null;
        }
        int src_w = wallpaper.getWidth();
        int src_h = wallpaper.getHeight();
        if (src_w > 128 && src_h > 128) {
            return wallpaper;
        }
        int nx = (int)Math.ceil(128.0 / (double)src_w);
        int ny = (int)Math.ceil(128.0 / (double)src_h);
        int w = src_w * nx;
        int h = src_h * ny;
        BufferedImage wallpaperNew = new BufferedImage(w, h, 2);
        Graphics2D g = wallpaperNew.createGraphics();
        try {
            this.drawWallpaper(g, w, h, wallpaper, src_w, src_h);
        }
        finally {
            g.dispose();
        }
        return wallpaperNew;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

