/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.MenuData;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuDataFactory
extends AbstractCollection<MenuDataFactory> {
    private String name;
    private boolean checkbox;
    private ActionListener actionListener;
    private MenuDataFactory[] factories;

    public MenuDataFactory(String name) {
        this(name, false, null, null);
    }

    public MenuDataFactory(String name, MenuDataFactory[] factories) {
        this(name, false, null, factories);
    }

    public MenuDataFactory(String name, ActionListener actionListener) {
        this(name, false, actionListener, null);
    }

    public MenuDataFactory(String name, boolean checkbox, ActionListener actionListener) {
        this(name, checkbox, actionListener, null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }

    public MenuDataFactory(String name, boolean checkbox, ActionListener actionListener, MenuDataFactory[] factories) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (factories == null) {
            factories = new MenuDataFactory[]{};
        }
        this.name = name;
        this.checkbox = checkbox;
        this.actionListener = actionListener;
        this.factories = factories;
    }

    public MenuData createMenuData(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        String text = props.getProperty(this.name + ".text");
        String mnemonic = props.getProperty(this.name + ".mnemonic");
        String mnemonicDisp = props.getProperty(this.name + ".mnemonicDisp");
        String ignoreMacOSX = props.getProperty(this.name + ".ignoreMacOSX");
        String shortcutKey = props.getProperty(this.name + ".shortcut-key");
        MenuData menuData = new MenuData();
        menuData.setName(this.getName());
        menuData.setCheckbox(this.isCheckbox());
        menuData.setText(text);
        if (mnemonic != null && mnemonic.length() > 0) {
            menuData.setMnemonic(Character.valueOf(mnemonic.charAt(0)));
            menuData.setMnimonicDisp(mnemonicDisp);
        }
        menuData.setIgnoreMacOSX(ignoreMacOSX != null && Boolean.valueOf(ignoreMacOSX) != false);
        menuData.setActionListener(this.actionListener);
        menuData.setShortcutKey(shortcutKey);
        for (MenuDataFactory factory : this.factories) {
            if (factory != null) {
                menuData.add(factory.createMenuData(props));
                continue;
            }
            menuData.add(null);
        }
        return menuData;
    }

    @Override
    public int size() {
        return this.factories.length;
    }

    @Override
    public Iterator<MenuDataFactory> iterator() {
        return new Iterator<MenuDataFactory>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < MenuDataFactory.this.factories.length;
            }

            @Override
            public MenuDataFactory next() {
                if (this.idx >= MenuDataFactory.this.factories.length) {
                    throw new NoSuchElementException();
                }
                return MenuDataFactory.this.factories[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

